% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productOrder.R
\name{productOrder}
\alias{productOrder}
\alias{\%po\%}
\title{Product order between two posets}
\usage{
productOrder(x, y, sep = "-")

x \%po\% y
}
\arguments{
\item{x}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}

\item{y}{an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details.}

\item{sep}{a character object indicating the separator to be used to paste profiles names.}
}
\value{
an S4 object of class \code{Rcpp_POSet}, see \code{\link[POSetR]{poset}} for details
}
\description{
The function returns the product poset of two posets \code{X} and \code{Y}.
}
\examples{
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)
p <- poset(x = dom)
q <- chain(1:3)
plot(p \%po\% q)

}
\references{
\insertRef{davey2002introduction}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}
}
