% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPregNodeViz.R
\name{PPregNodeViz}
\alias{PPregNodeViz}
\title{Node visualization}
\usage{
PPregNodeViz(PPTreeregOBJ,node.id,Rule=5)
}
\arguments{
\item{PPTreeregOBJ}{PPTreereg class object - a model to be explained}

\item{node.id}{node ID of inner or final node}

\item{Rule}{split rule
1: mean of two group means
2: weighted mean of two group means - weight with group size
3: weighted mean of two group means - weight with group sd
4: weighted mean of two group means - weight with group se
5: mean of two group medians
6: weighted mean of two group medians - weight with group size
7: weighted mean of two group median - weight with group IQR
8: weighted mean of two group median - weight with group IQR
                                       and group size}
}
\value{
An object of the class \code{ggplot}
}
\description{
Visualize node in projection pursuit regression tree.
}
\details{
This function is developed for the visualization of inner and final nodes.
Visual representation of the projection coefficient value of each node and
the result of projected data help understand growth process of the projection pursuit regression tree.
For the inner node, two plots are provided - the bar chart style plot with
projection pursuit coefficients of each variable, the histogram of the
projected data.
For the final node, scatter plot of observed Y vs. fitted Y according to the final rules.
}
\examples{
data(dataXY)
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
PPregNodeViz(Model,node.id=1)
PPregNodeViz(Model,node.id=4)

}
\keyword{tree}
