\name{plot.sbh}

\alias{plot.sbh}

\alias{plot}

\title{2D Visualization of Data Scatter and Encapsulating Box}

\description{
  S3-method plot function for two-dimensional visualization of scatter of data points 
  and cross-validated encapsulating box of a \code{sbh} object for the highest risk (inbox) versus
  lower-risk (outbox) groups (PRSP), and between the two specified fixed groups (PRGSP), 
  if this option is used. The scatter plot is done for a given peeling step (or number of steps) 
  of the peeling sequence (inner loop of our PRSP or PRGSP) and in a given plane of the used covariates 
  of the \code{sbh} object, both specified by the user.
}

\usage{
  \method{plot}{sbh}(x,
     main = NULL,
     proj = c(1,2), 
     steps = 1:x$cvfit$cv.nsteps,
     pch = 16, 
     cex = 0.5, 
     col = c(1,2), 
     boxes = TRUE,
     col.box = rep(2,length(steps)), 
     lty.box = rep(2,length(steps)), 
     lwd.box = rep(1,length(steps)),
     add.caption.box = boxes,
     text.caption.box = paste("Step: ", steps, sep=""),
     pch.group = c(1,1),
     cex.group = c(1,1),
     col.group = c(3,4),
     add.caption.group = ifelse(test = x$cvarg$peelcriterion == "grp", 
                                 yes = TRUE, 
                                 no = FALSE),
     text.caption.group = levels(x$groups), 
     device = NULL, 
     file = "Scatter Plot", 
     path = getwd(), 
     horizontal = FALSE, 
     width = 5, 
     height = 5, ...)
}

\arguments{
  \item{x}{
    Object of class \code{sbh} as generated by the main function \code{\link[PRIMsrc]{sbh}}.
  }
  \item{main}{
    \code{Character} \code{vector}. Main Title. 
    Defaults to \code{NULL}.
  }
  \item{proj}{
    \code{Integer} \code{vector} of length two, specifying the two dimensions of 
    the projection plane in which the scatter plot is to be plotted. 
    Defaults to first two dimensions: \{1,2\}.
  }
  \item{steps}{
    \code{Integer} \code{vector}. Vector of peeling steps at which to plot the 
    inbox samples and box vertices. 
    Defaults to all the peeling steps of \code{sbh} object \code{x}.
  }
  \item{pch}{
    \code{Integer} scalar specifying the symbol for the outbox and inbox 
    data points (Defaults to 16 for both).
  }
  \item{cex}{
    \code{Numeric} scalar specifying the symbol expansion for the outbox 
    and inbox data points (Defaults to 0.5 for both).
  }
  \item{col}{
    \code{Integer} \code{vector} specifying the symbol color for the outbox 
    and inbox data points (Defaults to "black" and "red", respectively). 
  }
  \item{boxes}{
    \code{Logical} scalar. Shall the encapsulating box(es) be plotted as well? 
    Default to \code{TRUE}.
  }
  \item{col.box}{
    \code{Integer} \code{vector} of line color of box vertices for each step. 
    Defaults to vector of 2's (red) of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{lty.box}{
    \code{Integer} \code{vector} of line type of box vertices for each step. 
    Defaults to vector of 2's of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{lwd.box}{
    \code{Integer} \code{vector} of line width of box vertices for each step. 
    Defaults to vector of 1's of length the number of steps. 
    The vector is reused cyclically if it is shorter than the number of steps.
  }
  \item{add.caption.box}{
    \code{Logical} scalar. Shall the caption be plotted? 
    Defaults to \code{boxes} value.
  }
  \item{text.caption.box}{
    \code{Character} \code{vector} of caption content. 
    Defaults to \code{paste("Step: ", steps, sep="")}.
  }
  \item{pch.group}{
    \code{Integer} \code{vector} specifying the symbol for the two groups
     data points (Defaults to 0.5 for both).
  }
  \item{cex.group}{
    \code{Numeric} \code{vector} specifying the symbol expansion for the two groups
     data points (Defaults to 0.5 for both).
  }
  \item{col.group}{
    \code{Integer} \code{vector} specifying the symbol color for the two groups
     data points (Defaults to "green" and "blue"). 
  }
  \item{add.caption.group}{
    \code{Logical} scalar. Shall the caption be plotted? 
    Defaults to \code{TRUE} or \code{FALSE}, 
    depending on \code{x$cvarg$peelcriterion}.
  }
  \item{text.caption.group}{
    \code{Character} \code{vector} of caption content. 
    Defaults to \code{levels(x$groups)}.
  }
  \item{device}{
    Graphic display device in \{\code{NULL}, "PS", "PDF"\}. 
    Defaults to \code{NULL} (standard output screen).
    Currently implemented graphic display devices are "PS" (Postscript) 
    or "PDF" (Portable Document Format).
  }
  \item{file}{
    File name for output graphic. Defaults to "Scatter Plot".
  }
  \item{path}{
    Absolute path (without final (back)slash separator). 
    Defaults to working directory path.
  }
  \item{horizontal}{
    \code{Logical} scalar. Orientation of the printed image. 
    Defaults to \code{FALSE}, that is potrait orientation.
  }
  \item{width}{
    \code{Numeric} scalar. Width of the graphics region in inches. 
    Defaults to 5.
  }
  \item{height}{
    \code{Numeric} scalar. Height of the graphics region in inches. 
    Defaults to 5.
  }
  \item{\dots}{
    Generic arguments passed to other plotting functions.
  }
}

\details{
  Produces a proportional scatter plot where distances between points are represented accurately on screen 
  (graphical parameter \code{asp}=1).The window is set up so that one data unit in the x direction is equal 
  in length to one data unit in the y direction.
  
  The two dimensions (\code{proj}) of the projection plane, in which the scatter plot is to be plotted, 
  must be a subset of the used covariates of the \code{sbh} object. If the number of used covariates in the 
  \code{sbh} object is zero, the scatterplot will not be drawn. If the number of used covariates is one, 
  the scatterplot will be drawn using one of the two specified dimensions of argument \code{proj}.
  
  The scatterplot is drawn on a graphical device with geometrically equal scales on 
  the \eqn{x} and \eqn{y} axes.
}

\value{
  Invisible. None. Displays the plot(s) on the specified \code{device}.
}

\author{
    \itemize{
        \item "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
        \item "Michael Choe, M.D." \email{mjc206@case.edu}
        \item "Michael LeBlanc, Ph.D." \email{mleblanc@fhcrc.org}
        \item "Alberto Santana, MBA." \email{ahs4@case.edu}
        \item "J. Sunil Rao, Ph.D." \email{Rao@biostat.med.miami.edu}
    }
    Maintainer: "Jean-Eudes Dazard, Ph.D." \email{jean-eudes.dazard@case.edu}
}

\references{
    \itemize{
        \item Dazard J-E. and Rao J.S. (2018).
              "\emph{Variable Selection Strategies for High-Dimensional Survival Bump Hunting using Recursive Peeling Methods.}"
              (in prep).
        \item Rao J.S., Huilin Y. and Dazard J-E. (2018).
              "\emph{Disparity Subtyping: Bringing Precision Medicine Closer to Disparity Science.}"
              (in prep).
        \item Diaz-Pachon D.A., Saenz J.P., Dazard J-E. and Rao J.S. (2018).
              "\emph{Mode Hunting through Active Information.}"
              (in press).
        \item Diaz-Pachon D.A., Dazard J-E. and Rao J.S. (2017).
              "\emph{Unsupervised Bump Hunting Using Principal Components.}"           
              In: Ahmed SE, editor. Big and Complex Data Analysis: Methodologies and Applications. 
              Contributions to Statistics, vol. Edited Refereed Volume. 
              Springer International Publishing, Cham Switzerland, p. 325-345.
        \item Yi C. and Huang J. (2017).
              "\emph{Semismooth Newton Coordinate Descent Algorithm for Elastic-Net Penalized Huber Loss Regression and Quantile Regression}."
              J. Comp Graph. Statistics, 26(3):547-557.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2016).
              "\emph{Cross-validation and Peeling Strategies for Survival Bump Hunting using Recursive Peeling Methods.}"
              Statistical Analysis and Data Mining, 9(1):12-42.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2015).
              "\emph{R package PRIMsrc: Bump Hunting by Patient Rule Induction Method for Survival, Regression and Classification.}"
              In JSM Proceedings, Statistical Programmers and Analysts Section. Seattle, WA, USA.
              American Statistical Association IMS - JSM, p. 650-664.
        \item Dazard J-E., Choe M., LeBlanc M. and Rao J.S. (2014).
              "\emph{Cross-Validation of Survival Bump Hunting by Recursive Peeling Methods.}"
              In JSM Proceedings, Survival Methods for Risk Estimation/Prediction Section. Boston, MA, USA.
              American Statistical Association IMS - JSM, p. 3366-3380.
        \item Dazard J-E. and J.S. Rao (2010).
              "\emph{Local Sparse Bump Hunting.}"
              J. Comp Graph. Statistics, 19(4):900-92.
    }
}

\section{Acknowledgments}{
    This work made use of the High Performance Computing Resource in the Core Facility for Advanced Research Computing at Case Western Reserve University. 
    This project was partially funded by the National Institutes of Health NIH - National Cancer Institute (R01-CA160593) to J-E. Dazard and J.S. Rao.
}

\note{
  End-user plotting function.
}

\keyword{Exploratory Survival/Risk Analysis}
\keyword{Survival/Risk Estimation & Prediction}
\keyword{Non-Parametric Method}
\keyword{Cross-Validation}
\keyword{Bump Hunting}
\keyword{Rule-Induction Method}
