% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_crs_text.R
\name{proj_crs_text}
\alias{proj_crs_text}
\title{Generate a projection string.}
\usage{
proj_crs_text(source, format = 0L)
}
\arguments{
\item{source}{input projection specification one of ('PROJ4', 'WKT2',
'EPSG', 'PROJJSON', ... see the library documentation link in Details)}

\item{format}{integer, 0 for 'WKT', 1 for 'PROJ', 2 for 'PROJJSON'}
}
\value{
character string in requested format
}
\description{
Input any accepted format of 'PROJ' coordinate reference system specification.
Return value is a string in the requested format.
}
\details{
This function requires PROJ version 6.0 or higher to be useful. If not, this
function simply returns 'NA'.

See the \href{https://proj.org/development/reference/functions.html#transformation-setup}{library documentation}
for details on input and output formats.
}
\section{warning}{

Note that a PROJ string is not a full specification, in particular this means that a string like "+proj=laea" cannot be converted
to full WKT, because it is technically a transformation step not a crs. To get the full WKT form use a string like "+proj=laea +type=crs".
}

\examples{
cat(proj_crs_text("EPSG:4326", format = 0L))
proj_crs_text("EPSG:4326", format = 1L)
south55 <- "+proj=utm +zone=55 +south +ellps=GRS80 +units=m +no_defs +type=crs"
proj_crs_text(proj_crs_text(south55), 1L)
}
