% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorehelpers.R
\name{msgWrap}
\alias{msgWrap}
\title{msgWrap}
\usage{
msgWrap(msg)
}
\arguments{
\item{msg}{A quoted message.}
}
\value{
It returns \code{msg} formatted wrapped nicely for the console.
}
\description{
Helps format line-wrapping of long error and warning messages
}
\details{
This is just a shorter version of the following that makes my function code
easier to read:
\code{paste(strwrap(msg, exdent = 2, width = 70), collapse = "\n")}
It seems to work fine when embedded in \code{warning} or \code{stop}, but may
give unexpected output if called alone.
}
\examples{
txt <- "If you use 'itemsrev' to indicate items that
        must be reverse-coded before scoring,
        you must provide a valid numeric range to 'minmax'.
        For example, if your lowest possible item response
        is 0 and your highest possible response is 4,
        you would use 'minmax = c(0, 4)'."

warning(msgWrap(msg = txt))
}
