% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset_dep}
\alias{dataset_dep}
\alias{response_dep}
\alias{anchor_dep}
\alias{itemmap_dep}
\alias{data_dep}
\title{DEP dataset}
\description{
This dataset is associated with the following objects:
}
\details{
\itemize{
  \item \code{\link{response_dep}} a \code{\link{data.frame}} containing raw response data of 747 participants and 49 variables.
  \itemize{
    \item \code{prosettaid}. participant IDs.
    \item \code{EDDEP04 -- CESD20}. response to items.
  }
  \item \code{\link{itemmap_dep}} a \code{\link{data.frame}} containing the item map, describing the items in each instrument.
  \itemize{
    \item \code{item_order} item numeric IDs. This column refers to the column \code{item_order} in anchor item parameters.
    \item \code{instrument} the instrument ID that each item belongs to.
    \item \code{item_id} item ID strings. This column refers to column names in raw response data, excluding the participant ID column.
    \item \code{item_name} new item ID strings to be used in the combined scale.
    \item \code{ncat} the number of response categories.
  }
  \item \code{\link{anchor_dep}} a \code{\link{data.frame}} containing anchor item parameters for 28 items.
  \itemize{
    \item \code{item_order} item numeric IDs.
    \item \code{item_id} item ID strings. This column refers to column names in raw response data, excluding the participant ID column.
    \item \code{a} the discrimination (slope) parameter for the graded response model.
    \item \code{cb1 - cb4} the boundaries between each category-pair for the graded response model.
    \item \code{ncat} the number of response categories.
  }
  \item \code{\link{data_dep}} a \code{\linkS4class{PROsetta_data}} object containing the datasets above. See \code{\link{loadData}} for creating \code{\linkS4class{PROsetta_data}} objects.
}
}
\examples{

## load datasets into a PROsetta_data object
data_dep <- loadData(
  response = response_dep,
  itemmap  = itemmap_dep,
  anchor   = anchor_dep
)

## run descriptive statistics
runDescriptive(data_dep)

## run item parameter calibration on the response data, linking to the anchor item parameters
runLinking(data_dep, method = "FIXEDPAR")
}
\keyword{datasets}
