% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\docType{methods}
\name{plotInfo}
\alias{plotInfo}
\alias{plotInfo,SingleGroupClass-method}
\title{Plot scale information}
\usage{
plotInfo(
  object,
  data,
  theta = seq(-4, 4, 0.1),
  t_score = FALSE,
  scale_label = c(1, 2, "Combined"),
  color = c("red", "blue", "black"),
  lty = c(3, 2, 1)
)

\S4method{plotInfo}{SingleGroupClass}(
  object,
  data,
  theta = seq(-4, 4, 0.1),
  t_score = FALSE,
  scale_label = c(1, 2, "Combined"),
  color = c("red", "blue", "black"),
  lty = c(3, 2, 1)
)
}
\arguments{
\item{object}{a \code{\linkS4class{SingleGroupClass}} object from \code{\link{runCalibration}}.}

\item{data}{a \code{\linkS4class{PROsetta_data}} object.}

\item{theta}{theta values to plot on the x-axis.}

\item{t_score}{set to \code{TRUE} to convert thetas into T-scores.}

\item{scale_label}{names of each scale.}

\item{color}{line colors to plot.}

\item{lty}{line types to plot.}
}
\description{
\code{\link{plotInfo}} is a plotting function to visualize scale-level information.
}
\examples{
\donttest{
out_calib = runCalibration(data_asq, technical = list(NCYCLES = 1000))
plotInfo(out_calib, data_asq)
}

}
