\name{cstrata.psa}
\alias{cstrata.psa}

\title{Supports Multiple Methods for Defining and Visualizing (PS) Strata}

\description{Given propensity scores, allows strata to be directly user defined, possibly to: equalize sizes of strata, equalize the ranges of propensity scores, or to specify cut points on the unit interval. Once strata are created, a simple graphic is generated to visualize or judge strata for overlap and appropriateness. If a regression tree has been used, propensity scores are defined for each leaf of the tree.}

\usage{cstrata.psa(treatment, propensity, strata = NULL, int = NULL, 
tree = FALSE, minsize = 2, graphic = TRUE,  
colors = c("dark blue", "dark green"), 
xlab = "Estimated Propensity Scores with Random Heights", 
pch = c(16, 16))}

\arguments{
  \item{treatment}{Binary vector or factor defining the two treatments}
  \item{propensity}{Vector of same length as \code{treatment} containing estimated propensity scores.}
  \item{strata}{Either a vector of same length as \code{treatment} of predefined stratum number, or one integer \code{n} used to assign rows to \code{n} strata \code{propensity} scores, each of approximately the same number of cases.    If relatively few unique propensity scores have been defined (as from a classification tree) then the logical \code{tree} should be set equal to \code{TRUE}.}
  \item{int}{Either a number \code{m} used to divide \code{[0,1]} into \code{m} equal length subintervals, or a vector containing cut points between 0 and  1 that define subintervals (perhaps as suggested by loess.psa).  In either case the subintervals define strata, for which sizes can differ. }
  \item{tree}{Logical, default \code{FALSE}.  If there are few unique propensity scores, say from a recursively partitioned tree, then \code{TRUE} forces strata to be defined by the unique propensity scores.}
  \item{minsize}{Smallest allowable stratum-treatment size.  If violated, rows in the stratum are removed.  User may wish to redefine strata.}
  \item{graphic}{Logical, default \code{TRUE}.  If set to \code{FALSE} the graphic is not provided.}
  \item{colors}{2-ary color vector.  Sets the colors of the points in the graphic.  Default = \code{c("blue", "orange")}}
  \item{xlab}{Label for the x axis; default = \code{"Estimated Propensity Scores with Random Heights"}.}
  \item{pch}{2-ary vector; determines the shape of points in the graphic.  Default = \code{c(16, 16)}.}
  }

\value{
\item{Original.Strata}{Table of strata-treatment sizes before \code{minsize} evaluation.}
\item{Used.Strata}{Table of strata-treatment sizes after \code{minsize} evaluation.}
\item{strata}{Vector of the same length as \code{treatment}, indicating either the strata input by user or those created by the function.}
}

\author{
James E. Helmreich \email{ James.Helmreich@Marist.edu}

Robert M. Pruzek \email{RMPruzek@yahoo.com}
 	
KuangNan Xiong \email{harryxkn@yahoo.com} 
}

\seealso{
\code{\link{cv.bal.psa}}, \code{\link{loess.psa}}
}
\examples{
data(lindner)
attach(lindner)
lindner.ps <- glm(abcix ~ stent + height + female + 
      diabetic + acutemi + ejecfrac + ves1proc, 
      data = lindner, family = binomial)
ps <- lindner.ps$fitted
cstrata.psa(abcix, ps, strata = 5)	
cstrata.psa(abcix, ps, strata = 10)
cstrata.psa(abcix, ps, int = c(.37, .56, .87, 1))
}

\keyword{ hplot }

%% R CMD Rdconv --type=html --output=cstrata.psa.html /Users/ilfautetre/Documents/Spring2010/PSAGraphicsV2.0/man/cstrat.psa.Rd
