% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSTR.R
\name{EstPSTR}
\alias{EstPSTR}
\title{Estimate the PSTR model.}
\usage{
EstPSTR(use, im = 1, iq, par, vLower = 2, vUpper = 2,
  method = "L-BFGS-B")
}
\arguments{
\item{use}{an object of the class PSTR, created by \code{\link{NewPSTR}} function.}

\item{im}{specifies the number of switches in the transtion function. The default value is 1.}

\item{iq}{a column number (in \code{mQ}) or variable name specifying the transition variable to use.}

\item{par}{initial values for the parameters (\eqn{\delta} and \eqn{c}) to be optimized over. It is a vector of length \code{im}+1, where \code{im} is the number of switches.}

\item{vLower}{a vector or number of the lower offsets determining the lower bounds of the parameters. The lower bounds of the parameters are \code{par - vLower}.}

\item{vUpper}{a vector or number of the upper offsets determining the upper bounds of the parameters. The upper bounds of the parameters are \code{par + vUpper}.}

\item{method}{the method to be used in optimization. See the function \code{stats::optim}.}
}
\value{
a new object of the class PSTR containing the results from the estimation.

The object is a list containing the components made in \code{\link{NewPSTR}} and the following new components:
\item{iq}{specify which transition variable will be used in estimation.}
\item{delta}{the estimate of \eqn{\delta}.}
\item{c}{the estimates of \eqn{c}.}
\item{vg}{the values of the transition function given the estimates of \eqn{\delta} and \eqn{c} and the transition variables \eqn{q_{it}}.}
\item{beta}{the estimates of the coefficient parameters.}
\item{vU}{the residuals.}
\item{s2}{the variance of the residuals.}
\item{cov}{the covariance matrix of the estimates which is cluster-dependency and heteroskedasticity consistent.}
\item{est}{a vector of all the estimates}
\item{se}{a vector of the standard errors of all the estimates which is cluster-dependency and heteroskedasticity consistent.}
\item{mbeta}{a vector of the estimates of the parameters in the second extreme regime.}
\item{mse}{a vector of the standard errors of the estimates of the parameters in the second extreme regime.}
}
\description{
This function implements the estimation of the \code{\link{PSTR}} model.
}
\details{
The function needs the return value (an object of the class PSTR) from the \code{\link{NewPSTR}}. It copies the object, reuses its contents to estimate the correspdonding PSTR model, and then returns a new object of the class PSTR containing the results from the estimation. The user can choose to save the return value to a new object or simply to overwrite the object returned from \code{NewPSTR}.

The PSTR model to be estimated takes the logistic form in nonlinearity. Remember the \eqn{g} function in the model. It takes the form
\deqn{g(q_{it} ; \gamma, c) = \left( 1 + \exp \left( - \gamma \prod_{j=1}^{m} (q_{it} - c_j) \right) \right)^{-1}}
with \eqn{\gamma > 0} and \eqn{c_1 < c_2 < ... < c_m}. \eqn{\gamma} can be reparametrized as \eqn{\gamma = \exp{\delta}} where \eqn{\delta} is a real number.

The user should have obtained the information about which transition variable (\eqn{q_{it}}) to use (from \code{\link{LinTest}} and/or \code{\link{WCB_LinTest}}) in estimation before running the function to estimate the model.

The estimation function never change the existing values in the input PSTR object. It adds more values (attributes) into the input object and return.
}
\examples{
\donttest{
pstr = NewPSTR(Hansen99, dep='inva', indep=4:20, indep_k=c('vala','debta','cfa','sales'),
    tvars=c('vala'), iT=14) # create a new PSTR object

# "L-BFGS-B" is used by default
pstr = EstPSTR(use=pstr, im=1, iq=1, par=c(1.6,.5), vLower=4, vUpper=4)
# You can also choose the method yourself.
pstr = EstPSTR(use=pstr, im=1, iq=1, par=c(1.6,.5), method='CG')

print(pstr, "estimates", digits=6)
}

}
\seealso{
\code{\link{NewPSTR}}, \code{\link{LinTest}} and \code{\link{WCB_LinTest}}
}
\author{
Yukai Yang, \email{yukai.yang@statistik.uu.se}
}
\keyword{estimation}
