% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SumStat_cl.R
\name{SumStat_cl}
\alias{SumStat_cl}
\title{Calculate summary statistics for propensity score weighting with clustering (for binary treatment only)}
\usage{
SumStat_cl(
  ps.formula = NULL,
  trtgrp = NULL,
  data = NULL,
  weight = "overlap",
  delta = 0,
  nAGQ = 1L
)
}
\arguments{
\item{ps.formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the propensity score model to be fitted. Additional details of model specification are given under "Details".}

\item{trtgrp}{an optional character defining the "treated" population for estimating the average treatment effect among the treated (ATT). Only necessary if \code{weight = "treated"}. This option can also be used to specify the treatment (in a two-treatment setting). Default value is the last group in the alphebatic order.}

\item{data}{an data frame containing the variables in the propensity score model. If not found in data, the variables are taken from \code{environment(formula)}.}

\item{weight}{a character or vector of characters including the types of weights to be used. \code{"IPW"} specifies the inverse probability weights for estimating the average treatment effect among the combined population (ATE). \code{"treated"} specifies the weights for estimating the average treatment effect among the treated (ATT). \code{"overlap"} specifies the (generalized) overlap weights for estimating the average treatment effect among the overlap population (ATO), or population at clinical equipoise. \code{"matching"} specifies the matching weights for estimating the average treatment effect among the matched population (ATM). \code{"entropy"} specifies the entropy weights for the average treatment effect of entropy weighted population (ATEN). Default is \code{"overlap"}.}

\item{delta}{trimming threshold for estimated (generalized) propensity scores. Should be no larger than 1 / number of treatment groups. Default is 0, corresponding to no trimming.}

\item{nAGQ}{integer scalar - the number of points per axis for evaluating the adaptive Gauss-Hermite approximation to the log-likelihood.
Defaults to 1, corresponding to the Laplace approximation. Please refer to lme4 package for more details.}
}
\value{
SumStat_cl returns a \code{SumStat} object including a list of the following value:
treatment group, propensity scores, propensity score weights, effective sample sizes,
and balance statistics. A summary of \code{SumStat} can be obtained with \code{\link{summary.SumStat}}.

\describe{
\item{\code{ trtgrp}}{a character indicating the treatment group.}

\item{\code{ propensity}}{a data frame of estimated propensity scores.}

\item{\code{ ps.weights}}{a data frame of propensity score weights.}

\item{\code{ ess}}{a table of effective sample sizes. This serves as a conservative measure to
characterize the variance inflation or precision loss due to weighting, see Li and Li (2019).}

\item{\code{ unweighted.sumstat}}{A list of tables including covariate means and variances
by treatment group and standardized mean differences.}

\item{\code{ ATE.sumstat}}{If \code{"IPW"} is included in \code{weight}, this is a list of summary statistics using inverse probability weighting.}

\item{\code{ ATT.sumstat}}{If \code{"treated"} is included in \code{weight}, this is a list of summary statistics using the ATT weights.}

\item{\code{ ATO.sumstat}}{If \code{"overlap"} is included in \code{weight}, this is a list of summary statistics using the overlap weights.}

\item{\code{ ATM.sumstat}}{If \code{"matching"} is included in \code{weight}, this is a list of summary statistics using the matching weights.}

\item{\code{ ATEN.sumstat}}{If \code{"entropy"} is included in \code{weight}, this is a list of summary statistics using the entropy weights.}

\item{\code{ trim}}{If \code{delta > 0}, this is a table summarizing the number of observations before and after trimming.}

}
}
\description{
\code{SumStat_cl} is used to generate distributional plots of the estimated propensity scores and balance
diagnostics after propensity score weighting with two-level data.
}
\details{
A typical form for \code{ps.formula} is \code{treatment ~ terms+1|clusters} where \code{treatment} is the treatment
variable, \code{terms} is a series of terms
which specifies a linear predictor for \code{treatment}, and \code{clusters} is the cluster indicator. The current version supports two-level models and the random-effects term is required to be the last piece in the formula. \code{ps.formula} specifies a mixed-effects logistic regression
model for estimating propensity scores. The treatment group corresponds to the last group in the alphebatic order, unless otherwise specified by \code{trtgrp}.

Current version of \code{PSweight} allows for five types of propensity score weights used to estimate ATE (\code{"IPW"}), ATT {(\code{"treated"})}, and
ATO{(\code{"overlap"})}, ATM {\code{"matching"}} and ATEN \code{"entropy"}. These weights are members of a larger class of balancing weights defined in Li, Morgan, and Zaslavsky (2018).
When there is a practical violation of the positivity assumption, \code{delta} defines the symmetric
propensity score trimming rule following Crump et al. (2009). With multiple treatments, \code{delta} defines the
multinomial trimming rule introduced in Yoshida et al. (2019). The overlap weights can also be considered as
a data-driven continuous trimming strategy without specifying trimming rules, see Li, Thomas and Li (2019).
Additional details on balancing weights and generalized overlap weights for multiple treatment groups are provided in
Li and Li (2019). For details about matching weights and entropy weights, please refer to Li and Greene (2013) and Zhou, Matsouaka and Thomas (2020).
}
\examples{

data("psdata_cl")
# the propensity model
# ps.formula<-trt~cov1+cov2+cov3+cov4+cov5+cov6+(1|clt)

# using SumStat to estimate propensity scores
# msstat <- SumStat_cl(ps.formula, trtgrp="1", data=psdata_cl,
#   weight=c("IPW","overlap","treated","entropy","matching"))
#summary(msstat)

}
\references{
Crump, R. K., Hotz, V. J., Imbens, G. W., Mitnik, O. A. (2009).
Dealing with limited overlap in estimation of average treatment effects. Biometrika, 96(1), 187-199.

Li, L., Greene, T. (2013).
A weighting analogue to pair matching in propensity score analysis. The International Journal of Biostatistics, 9(2), 215-234.

Li, F., Morgan, K. L., Zaslavsky, A. M. (2018).
Balancing covariates via propensity score weighting.
Journal of the American Statistical Association, 113(521), 390-400.

Li, F., Thomas, L. E., Li, F. (2019).
Addressing extreme propensity scores via the overlap weights. American Journal of Epidemiology, 188(1), 250-257.

Li, F., Li, F. (2019). Propensity score weighting for causal inference with multiple treatments.
The Annals of Applied Statistics, 13(4), 2389-2415.

Zhou, Y., Matsouaka, R. A., Thomas, L. (2020).
Propensity score weighting under limited overlap and model misspecification. Statistical Methods in Medical Research 29(12), 3721-3756.

Li, F., Zaslavsky, A. M., & Landrum, M. B. (2013). Propensity score weighting with multilevel data. Statistics in Medicine, 32(19), 3373-3387.
}
