% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{ddist}
\alias{ddist}
\alias{rdist}
\alias{d.betap}
\alias{r.betap}
\alias{d.F}
\alias{r.F}
\alias{d.gamma}
\alias{r.gamma}
\alias{d.invGauss}
\alias{r.invGauss}
\alias{d.logLogis}
\alias{r.logLogis}
\alias{d.logNorm}
\alias{r.logNorm}
\alias{d.chi}
\alias{r.chi}
\alias{d.ray}
\alias{r.ray}
\title{Reparametrized Distributions}
\usage{
d.betap(x, mu, varphi, log = FALSE)

r.betap(n, mu, varphi)

d.F(x, mu, varphi, log = FALSE)

r.F(n, mu, varphi)

d.gamma(x, mu, varphi, log = FALSE)

r.gamma(n, mu, varphi)

d.invGauss(x, mu, varphi, log = FALSE)

r.invGauss(n, mu, varphi)

d.logLogis(x, mu, varphi, log = FALSE)

r.logLogis(n, mu, varphi)

d.logNorm(x, mu, varphi, log = FALSE)

r.logNorm(n, mu, varphi)

d.chi(x, mu, log = FALSE, ...)

r.chi(n, mu, ...)

d.ray(x, mu, log = FALSE, ...)

r.ray(n, mu, ...)
}
\arguments{
\item{x}{vector of real values}

\item{mu}{non-negative parameter (the distribution's mean. See \sQuote{Details})}

\item{varphi}{non-negative parameter}

\item{log}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}.}

\item{n}{sample size}

\item{...}{for compatibility with other functions}
}
\value{
For any avaliable \code{dist}, \code{ddist} gives the density and \code{rdist} generates random deviates.

The length of the result is determined by \code{n} for \code{rdist}, and is the maximum of the lengths of the numerical arguments for \code{rdist}.

The numerical arguments other than \code{n} are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\description{
Density function and random numbers generation for models with support on the positive real line.
}
\details{


\itemize{
\item For the reparametrized Beta-Prime distribution, the functions \link[extraDistr:BetaPrime]{dbetapr} and \link[extraDistr:BetaPrime]{rbetapr} are imported from the package \code{\link{extraDistr}}. The following holds
\deqn{shape1 = mu*varphi}
\deqn{shape2 = varphi + 1}
\deqn{scale = 1}
}

\itemize{
\item For the reparametrized F distribution, the functions \link[stats:Fdist]{df} and  \link[stats:Fdist]{rf} are imported from \code{\link{stats}}. The following holds
\deqn{df1 = varphi}
\deqn{df2 = 2*mu/(mu - 1)}
so that the parameter \eqn{\mu} must satisfy \eqn{\mu > 1}.
}

\itemize{
\item For the reparametrized Gamma distribution, the functions \link[stats:GammaDist]{dgamma} and  \link[stats:GammaDist]{rgamma} are imported from \code{\link{stats}}. The following holds
\deqn{shape = varphi}
\deqn{rate = varphi/mu}
}

\itemize{
\item For the reparametrized Inverse Gaussian distribution, the functions \link[SuppDists:invGauss]{dinvGauss} and \link[SuppDists:invGauss]{rinvGauss} are imported from \code{SuppDists}. The following holds
\deqn{nu = mu}
\deqn{lambda = 1/varphi}
}

\itemize{
\item For the reparametrized Log-logistic distribution, the functions \link[actuar:Loglogistic]{dllogis} and \link[actuar:Loglogistic]{rllogis} a are imported from \code{actuar}. The following holds
\deqn{shape = varphi}
\deqn{rate = (pi/varphi)/(mu*sin(pi/varphi))}
}

\itemize{
\item For the reparametrized Log-Normal distribution, the functions \link[stats:Lognormal]{dlnorm} and \link[stats:Lognormal]{rlnorm} are imported from \code{\link{stats}}. The following holds
\deqn{meanlog = log(mu) - varphi^2/2}
\deqn{sdlog = varphi}
}

\itemize{
\item For the reparametrized Chi-squared F distribution, the functions \link[stats:Chisquare]{dchisq} and \link[stats:Chisquare]{rchisq} are imported from \code{\link{stats}}. The following holds
\deqn{df = mu}
}

\itemize{
\item For the reparametrized Rayleigh distribution, the functions \link[extraDistr:Rayleigh]{drayleigh} and \link[extraDistr:Rayleigh]{rrayleigh} are imported from \code{\link{extraDistr}}. The following holds
\deqn{sigma = mu/sqrt(pi/2)}
}
}
