% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_MBRgain}
\alias{plot_MBRgain}
\title{Plot MaxQuant Match-between-runs id transfer performance.}
\usage{
plot_MBRgain(data, title_sub = "")
}
\arguments{
\item{data}{A data.frame with columns as described above}

\item{title_sub}{Subtitle text}
}
\value{
GGplot object
}
\description{
The plots shows the different categories of peak classes
}
\details{
The input is a data.frame with columns
  'fc.raw.file' - raw file name
  'single' - fraction of peptides with are represent only once
  'multi.inRT' - fraction of peptides with are represent multiple times, 
                 but within a certain RT peak width
  'multi.outRT' - fraction of peptides with are represent multiple times,
                  with large RT distance
  'sample' - raw file
where each row represents one peptide sequence.
}
\examples{
 data = data.frame(fc.raw.file = paste("file", letters[1:4]),
                   abs = c(5461, 5312, 3618, 502), 
                   pc = c(34, 32, 22, 2))
 plot_MBRgain(data, "MBR gain: 18\%")

}

