% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jovanovicLM.R
\name{jovanovic.LM}
\alias{jovanovic.LM}
\title{Jovanovic Isotherm Linear Analysis}
\usage{
jovanovic.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for the Jovanovic isotherm,
and model error analysis
}
\description{
The Jovanovic isotherm model was built upon the assumptions
based on the Langmuir isotherm model with few possible inclusions of mechanical
contact among the desorbing and adsorbing molecules. The adjustment of the
adsorption surface from this model made the equation less effective in the
physical adsorption but can be applied to adsorption with both mobile and
localized monolayer without lateral interaction. Moreover, the equation of
the Jovanovic isotherm model is able to reach the limit of saturation when
there is high concentration, while it reduces to Henry's Law at low concentration.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
jovanovic.LM(Ce,Qe)
}
\references{
Jovanović, D.S. (1969) <doi:10.1007/BF01542531> Physical adsorption of gases.
Kolloid-Z.u.Z.Polymere 235, 1214–1225.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
