% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_load.R
\name{airnow_load}
\alias{airnow_load}
\title{Load AirNow Monitoring Data}
\usage{
airnow_load(startdate, enddate, stateCodes = NULL, monitorIDs = NULL,
  parameter = "PM2.5",
  baseUrl = "https://smoke.airfire.org/RData/AirNowTech/")
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{stateCodes}{vector of state codes passed on to \link{monitor_subset}}

\item{monitorIDs}{vector of monitor IDs passed on to \link{monitor_subset}
When set to NULL, the function returns all the monitor IDs available in the metadata}

\item{parameter}{parameter of interest}

\item{baseUrl}{base URL for AirNow meta and data files}
}
\value{
A \emph{ws_monitor} object with AirNow data.
}
\description{
When given the startdate, enddate, monitorIDs and parameter of interest, the function retrieves the 
meta and data files from the archive at \code{baseUrl} (or local directory) and returns a \emph{ws_monitor} object
after subsetting by time, state and monitor ID.
}
\examples{
\dontrun{
airnow <- airnow_load(20150901, 20150930)
airnow_conus <- monitor_subset(airnow, stateCodes=CONUS)
monitorLeaflet(airnow_conus)
}
}
\keyword{AirNow}
