% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esriMap_getMap.R
\name{esriMap_getMap}
\alias{esriMap_getMap}
\title{Download a Spatial Raster Object from ESRI}
\usage{
esriMap_getMap(centerLon = NULL, centerLat = NULL, bboxString = NULL,
  bboxSR = "4326", maptype = "worldStreetMap", zoom = 12, width = 640,
  height = 640, crs = sp::CRS("+init=epsg:4326"), additionalArgs = NULL)
}
\arguments{
\item{centerLon}{map center longitude}

\item{centerLat}{map center latitude}

\item{bboxString}{comma separated string with bounding box (xmin, ymin, xmax, ymax). If not null, centerLon, centerLat, and zoom are ignored.}

\item{bboxSR}{spatial reference of the bounding box}

\item{maptype}{map type}

\item{zoom}{map zoom level; corresponds to googleMaps zoom level}

\item{width}{width of image, in pixels}

\item{height}{height of image, in pixels}

\item{crs}{object of class CRS. The Coordinate Reference System (CRS) for the returned map. If the CRS of the downloaded
map does not match, it will be projected to the specified CRS using \code{raster::projectRaster}.}

\item{additionalArgs}{character string with additional arguments to be pasted into the image URL eg. \code{"&rotation=90"}}
}
\value{
A rasterBrick object which can be plotted with \code{esriMap_plotOnStaticMap()} or \code{raster::plotRGB()} and serve as a base plot.
}
\description{
Downloads a PNG from ESRI and creates a \code{raster::rasterBrick} object with layers for red, green, and blue.
This can then passed as the \code{mapRaster} object to the \code{esriMap_plotOnStaticMap()} function for plotting.

Available \code{maptypes} include:
\itemize{
\item{natGeo}
\item{worldStreetMap}
\item{worldTopoMap}
\item{satellite}
\item{deLorme}
}

Additional base maps are found at:
\url{http://resources.arcgis.com/en/help/arcgis-rest-api/index.html#/Basemaps/02r3000001mt000000/}
}
\note{
The spatial reference of the image when it is downloaded is 3857. If the crs argument is different, projecting may cause 
the size and extent of the image to differ very slightly from the input, on a scale of 1-2 pixels or 10^-3 degrees. 

If bboxString is specified and the bbox aspect ratio does not match the width/height aspect ratio the extent is resized to prevent
the map image from appearing stretched, so the map extent may not match the bbox argument exactly.
}
\examples{
\dontrun{
map <- esriMap_getMap(-122.3318, 47.668)
esriMap_plotOnStaticMap(map)
}
}
\references{
\url{http://resources.arcgis.com/en/help/arcgis-rest-api/index.html#/Export_Map/02r3000000v7000000/}
}
\seealso{
\code{\link{esriMap_plotOnStaticMap}}
}
\keyword{plotting}
