% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_subsetByDistance.R
\name{monitor_subsetByDistance}
\alias{monitor_subsetByDistance}
\title{Subset ws_monitor Object by Distance from Target Location}
\usage{
monitor_subsetByDistance(
  ws_monitor,
  longitude = NULL,
  latitude = NULL,
  radius = 50,
  count = NULL
)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{longitude}{target longitude from which the radius will be calculated}

\item{latitude}{target latitude from which the radius will be calculated}

\item{radius}{distance (km) of radius from target location -- default=300}

\item{count}{number of grid cells to return}
}
\value{
A \emph{ws_monitor} object with monitors near a location.
}
\description{
Subsets \code{ws_monitor} to include only those monitors (or grid cells)
within a certain radius of a target location. If no monitors (or grid cells) fall
within the specified \code{radius}, \code{ws_monitor$data} and \code{ws_monitor$meta}
are set to \code{NULL}.

When \code{count} is used, a \emph{ws_monitor} object is created containing \strong{up to}
\code{count} monitors, ordered by increasing distance from the target location. Thus, note that the number
of monitors (or grid cells) returned may be less than the specified \code{count} value if fewer than
\code{count} monitors (or grid cells) are found within the specified \code{radius} of the target location.
}
\examples{
\donttest{
library(PWFSLSmoke)

# Napa Fires -- October, 2017
ca <- airnow_loadAnnual(2017) \%>\%
  monitor_subset(tlim=c(20171001,20171101), stateCodes='CA')
Vallejo <- monitor_subset(ca, monitorIDs='060950004_01')
Napa_Fires <- monitor_subsetByDistance(ca,
                                       longitude = Vallejo$meta$longitude,
                                       latitude = Vallejo$meta$latitude,
                                       radius = 50)

if ( interactive() ) {
  monitor_leaflet(Napa_Fires)
}
}
}
\seealso{
monitorDistance
}
\keyword{ws_monitor}
