% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/staticmap_getStamenmapBrick.R
\name{staticmap_getStamenmapBrick}
\alias{staticmap_getStamenmapBrick}
\title{Create a rasterBrick from stamenmap tiles}
\usage{
staticmap_getStamenmapBrick(
  centerLon = NULL,
  centerLat = NULL,
  maptype = "terrain",
  zoom = 12,
  width = 640,
  height = 640,
  bbox = NULL,
  crs = sp::CRS("+init=epsg:4326"),
  tileCacheDir = tempdir()
)
}
\arguments{
\item{centerLon}{map center longitude}

\item{centerLat}{map center latitude}

\item{maptype}{map type}

\item{zoom}{map zoom level; corresponds to \code{ggmap::get_map()} zoom level}

\item{width}{width of image, in pixels}

\item{height}{height of image, in pixels}

\item{bbox}{bounding box vector (lonLo, latLo, lonHi, latHi). If not null,
\code{centerLon}, \code{centerLat}, and \code{zoom} are ignored.}

\item{crs}{object of class CRS. The Coordinate Reference System (CRS) for the
returned map. If the CRS of the downloaded map does not match, it will be
projected to the specified CRS using \code{raster::projectRaster}.}

\item{tileCacheDir}{Optional location for cached tiles.}
}
\value{
A rasterBrick object which can be plotted with
\code{staticmap_plotRasterBrick()} or \code{raster::plotRGB()} and serve as a
base plot.
}
\description{
Downloads a PNG from the stamenmap tile server and creates a
\code{raster::rasterBrick} object with layers for red, green, and blue. This
can then passed as the \code{rasterBrick} object to the
\code{staticmap_plotRasterBrick()} function for plotting.

Stamen maps tiles are freely available (April, 2019) and are described at the
following URL:

\url{http://maps.stamen.com/#terrain/12/37.7706/-122.3782}

"These tiles are made available as part of the CityTracking project, funded
by the Knight Foundation, in which Stamen is building web services and open
source tools to display public data in easy-to-understand, highly visual
ways."
}
\note{
The spatial reference of the image when it is downloaded is 3857. If
the crs argument is different, projecting may cause the size and extent of
the image to differ very slightly from the input, on a scale of 1-2 pixels or
10^-3 degrees.

If bbox is specified and the bbox aspect ratio does not match the
width/height aspect ratio the extent is resized to prevent the map image from
appearing stretched, so the map extent may not match the bbox argument
exactly.
}
\examples{
\dontrun{
rasterBrick <- staticmap_getStamenmapBrick(-122.3318, 47.668)
staticmap_plotRasterBrick(rasterBrick)
}
}
\seealso{
\code{\link{staticmap_getRasterBrick}}

\code{\link{staticmap_plotRasterBrick}}
}
\keyword{plotting}
