% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epa_createMonitorObject.R
\name{epa_createMonitorObject}
\alias{epa_createMonitorObject}
\title{Download and convert hourly EPA air quality data}
\usage{
epa_createMonitorObject(
  zipFile = NULL,
  zeroMinimum = TRUE,
  addGoogleMeta = TRUE
)
}
\arguments{
\item{zipFile}{absolute path to monitoring data .zip file}

\item{zeroMinimum}{logical specifying whether to convert negative values to zero}

\item{addGoogleMeta}{logicial specifying wheter to use Google elevation and reverse geocoding services}
}
\value{
A \emph{ws_monitor} object with EPA data.
}
\description{
Convert EPA data into a \emph{ws_monitor} object, ready for use with all \code{monitor_~} functions.
}
\note{
Before running this function you must first enable spatial data capabilities as in the example.
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

initializeMazamaSpatialUtils()
zipFile <- epa_downloadData(2016, "88101", downloadDir = '~/Data/EPA')
mon <- epa_createMonitorObject(zipFile, addGoogleMeta = FALSE)

}, silent = FALSE)
}
}
\references{
\href{https://aqs.epa.gov/aqsweb/airdata/download_files.html#Raw}{EPA AirData Pre-Generated Data Files}

\href{https://aqs.epa.gov/aqsweb/airdata/FileFormats.html#_format_3}{file format description}
}
\keyword{EPA}
