% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_collapse.R
\name{monitor_collapse}
\alias{monitor_collapse}
\title{Collapse a ws_monitor Object into a ws_monitor Object with a Single
Monitor}
\usage{
monitor_collapse(ws_monitor, longitude = NULL, latitude = NULL,
  monitorID = "generated_id", FUN = mean, na.rm = TRUE, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object.}

\item{longitude}{Longitude of the collapsed monitoring station.}

\item{latitude}{Latitude of the collapsed monitoring station.}

\item{monitorID}{Monitor ID assigned to the collapsed monitoring station.}

\item{FUN}{Function to be applied to all the monitors at a single time index.}

\item{na.rm}{Logical specifying whether NA values should be ignored when FUN
is applied.}

\item{...}{additional arguments to be passed on to the \code{apply()} function.}
}
\value{
A \emph{ws_monitor} object with meta and data that for the the
collapsed single monitor
}
\description{
Collapses data from all the monitors in \code{ws_monitor} into a
single-monitor \emph{ws_monitor} object using the function provided in the
\code{FUN} argument. The single-monitor result will be located at the mean
longitude and latitude unless \code{longitude} and \code{latitude}
parameters are specified.

Any columns of meta that are common to all monitors will be retained in
the returned \emph{ws_monitor} meta.
}
\note{
After \code{FUN} is applied, values of \code{+Inf} and \code{-Inf} are
converted to \code{NA}. This is a convenience for the common case where
\code{FUN=min} or \code{FUN=max} and some of the timesteps have all missing
values. See the R documentation for \code{min} for an explanation.
}
\examples{
N_M <- Northwest_Megafires
# monitor_leaflet(N_M) # to identify Spokane monitorIDs
Spokane <- monitor_subsetBy(N_M, stringr::str_detect(N_M$meta$monitorID,'^53063'))
Spokane_min <- monitor_collapse(Spokane, monitorID='Spokane_min', FUN=min)
Spokane_max <- monitor_collapse(Spokane, monitorID='Spokane_max', FUN=max)
monitor_timeseriesPlot(Spokane, tlim=c(20150619,20150626),
                       style='gnats', shadedNight=TRUE)
monitor_timeseriesPlot(Spokane_max, col='red', type='s', add=TRUE)
monitor_timeseriesPlot(Spokane_min, col='blue', type='s', add=TRUE)
title('Spokane Range of PM2.5 Values, June 2015')
}
\keyword{ws_monitor}
