% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkgDiagram.R
\name{exportDiagram}
\alias{exportDiagram}
\title{exportDiagram}
\usage{
exportDiagram(diagram, fileName)
}
\arguments{
\item{diagram}{(\link[DiagrammeR]{grViz})\cr
Graph object from \link[PaRe]{pkgDiagram}.}

\item{fileName}{(\link[base]{character})\cr
Path to save the diagram to, as PDF.}
}
\value{
(\code{NULL})
}
\description{
Exports the diagram from \code{pkgDiagram} to a PDF-file.
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  # Run pkgDiagram on the Repository object.
  pkgDiagram(repo = repo) \%>\%
    # Export the diagram to a temp file.
    exportDiagram(fileName = tempfile())
}
}
