% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairwiseD.R
\name{pairwised}
\alias{pairwised}
\title{pairing up observations of variables}
\usage{
pairwised( data, measure = c("sum", "sumabs", "absdiff", "diffabs", "prod",
           "prodabs", "absprod", "abslogdiff", "abslogsum", "logdiffabs",
           "logsumabs", "if1", "if2", "custom"), exp.multiplier = 0,
           multiplier = 1, no.messages = FALSE,
           save.as = NULL, sep=";", dec="," )
}
\arguments{
\item{data}{a data.frame, list or path to the input file in csv, xlsx or xls format.}

\item{measure}{operation that should be applied to every pair of observations. Built in options contains (x denotes first observation and y denotes the second observation):
\itemize{
       \item "sum": x+y,
       \item "sumabs": |x|+|y|,
       \item "absdiff": |x-y|,
       \item "diffabs": |x|+|y|,
       \item "prod": x*y,
       \item "prodabs": |x|*|y|,
       \item "absprod": |x*y|,
       \item "abslogdiff": |ln(xC7y)|,
       \item "abslogsum": |ln(x*y)|,
       \item "logdiffabs": ln(|x|C7|y|),
       \item "logsumabs": ln(|x|*|y|),
       \item "if1": (x+y=1)->1 and (x+y<>1)->0,
       \item "if2": (x+y=2)->1 and (x+y<>2)->0.
       \item Moreover, option "custom" allows the user to specify any function of x and y.
}}

\item{exp.multiplier}{default value set to 0. Changes the decimal mark in all the observations in the input file. Useful in cases when, for example, natural logarithm must be taken
from a number that is very close to 0.}

\item{multiplier}{default value set 1. Multiplies all the observations in the input file.}

\item{no.messages}{efault value is FALSE. If FALSE, the package will show messages: about finishing the calculations, destination file, potential error and wrong format of the input file.}

\item{save.as}{in this argument, user can specify: path for the destination folder, name of the file and desired format. Argument is given in the following form: "path/name.format". For example: "C:/Myfiles/Rfiles/pairwised_data.csv". If the argument is not specified default is set as "current R directory/name_of_the_input_file_paiwise_result.format_of_input_file". User can specify csv, xls and xlsx as the output format. If user does not specify the file format, the format will be the same as of the input format or xlsx in the case of data.frame/list input. If argument is equal to "none", output file is not generated.}

\item{sep}{symbol to be used for values separator in the input csv file (works only if input file is set to be a csv file). Default value is ";"}

\item{dec}{symbol to be used for decimal separator in the input file. Default value is ","}
}
\value{
function returns its result as data.frame object.
}
\description{
Function for pairing up observations in panel data setting according to built in or user specified formula.h
}
\examples{
pairwised(data=GDPgrowth, multiplier = 1, exp.multiplier = 0, no.messages = TRUE,
        measure = c("sum","sumabs","logdiffabs","if1","abs(abs(x^3)-abs(y^3))"),
        save.as = "GDPgrowthRESULTS.csv")
}
