% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_covariate_balance}
\alias{get_covariate_balance}
\title{Calculate covariate balance}
\usage{
get_covariate_balance(
  matched.sets,
  data,
  covariates,
  use.equal.weights = FALSE,
  verbose = TRUE,
  plot = FALSE,
  reference.line = TRUE,
  legend = TRUE,
  ylab = "SD",
  ...
)
}
\arguments{
\item{matched.sets}{A \code{matched.set} object}

\item{data}{The time series cross sectional data set (as a \code{data.frame} object) used to produce the \code{matched.set} object. This data set should be identical to the one passed to \code{PanelMatch} and \code{PanelEstimate} to ensure consistent results.}

\item{covariates}{a character vector, specifying the names of the covariates for which the user is interested in calculating balance.}

\item{use.equal.weights}{logical. If set to TRUE, then equal weights will be assigned to control units, rather than using whatever calculated weights have been assigned. This is helpful for assessing the improvement in covariate balance as a result of refining the matched sets.}

\item{verbose}{logical. When TRUE, the function will return more information about the calculations/results. When FALSE, a more compact version of the results/calculations are returned.}

\item{plot}{logical. When TRUE, a plot showing the covariate balance calculation results will be shown. When FALSE, no plot is made, but the results of the calculations are returned. default is FALSE}

\item{reference.line}{logical indicating whether or not a horizontal line should be present on the plot at y = 0. Default is TRUE.}

\item{legend}{logical indicating whether or not a legend identifying the variables should be included on the plot. Default is TRUE.}

\item{ylab}{Label for y axis. Default is "SD". This is the same as the ylab argument to \code{plot}.}

\item{...}{Additional graphical parameters to be passed to the \code{plot} function in base R.}
}
\description{
Calculate covariate balance for user specified covariates across matched sets. Balance is assessed by taking the average
of the difference between the values of the specified covariates for the treated unit(s) and the weighted average of
the control units across all matched sets. Results are standardized and are expressed in standard deviations.
Balance is calculated for each period in the specified lag window.
}
\examples{
#add some additional data to data set for demonstration purposes
dem$rdata <- runif(runif(nrow(dem)))
pm.obj <- PanelMatch(lead = 0:3, lag = 4, time.id = "year", unit.id = "wbcode2", treatment = "dem",
                    outcome.var ="y", refinement.method = "mahalanobis",
                    data = dem, match.missing = TRUE,
                    covs.formula = ~ tradewb + rdata + I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                    size.match = 5, qoi = "att")
get_covariate_balance(pm.obj$att, dem, covariates = c("tradewb", "rdata"),
                         ylim = c(-2,2))
get_covariate_balance(pm.obj$att, dem, covariates = c("tradewb", "rdata"),
                         plot = TRUE, ylim = c(-2,2))

}
