% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Preprocessing.R
\name{Preprocess}
\alias{Preprocess}
\title{As a data preprocessing function, sets some global variables that are not visible to the user}
\usage{
Preprocess(Fpath="",fn="",tname="",mc=NULL,icsv=NULL,itif=NULL,nblock=6,ncore=2,Fc=1)
}
\arguments{
\item{Fpath}{: the path of file}

\item{fn}{: Name of the folder in which the soil data is stored}

\item{tname}{: Standard soil files, which can be used as sample files (under in the FolderName)}

\item{mc}{: Read file mode (using data sets, or read yourself)}

\item{icsv}{: Use df.input from the built-in dataset)}

\item{itif}{: Use df.dem in the built-in data set)}

\item{nblock}{: the number of blocks for data cutting}

\item{ncore}{: Computes the CPU's kernel in parallel(fill in according to the computer configuration)}

\item{Fc}{: the encoding of file}
}
\description{
As a data preprocessing function, sets some global variables that are not visible to the user
}
\examples{
#####################################################################
##  Example code 1                                                 ##
##  Select your own reading method, as shown below                 ##
#####################################################################
mydatas <- system.file("extdata", "all.input.csv", package = "ParallelDSM")
sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")
Preprocess(mydatas,sampledatas,"twi.tif")

#####################################################################
##  Example code 2 (It is highly recommended)                      ##
##  If you want to use test cases, load the relevant data sets     ##
#####################################################################
#  Select the data set that comes with this package

# data("df.input")
# data("df.dem")

#####################################################################
##  Use the data file references that come with this package       ##
#####################################################################
# sampledatas <- system.file("extdata", "covariate", package = "ParallelDSM")

#####################################################################
## Use preprocessor functions to process the data that is loaded in##
#####################################################################
# Preprocess(fn = sampledatas,mc = TRUE,icsv = df.input,itif = df.dem)

############################################################################
## This function is the main function that performs parallel computations ##
## The outpath field refers to the filename of the data output            ##
## The mymodels field has three modes to choose from: QRF,RF and MLR      ##
## ‘QRF’ stands for Random Forest Model Prediction Method                 ##
## ‘RF’ stands for Machine Learning Model Prediction Method               ##
## ‘MLR’ stands for Multiple Linear Regression Prediction Model           ##
## 'from' and 'to' are reserved fields that can be left unused by the user##
############################################################################

#DsmParallel(outpath = "myoutputs",mymodels = "MLR",from=1,to=200)

}
\references{
Breiman, L. (2001). Random forests. Mach. Learn. 45, 5–32.
Meinshausen, N. (2006) "Quantile Regression Forests", Journal of Machine Learning Research 7,
983-999 http://jmlr.csail.mit.edu/papers/v7/
Song, X.D., Ge, G.Q., Zhang, G.L. and Wu, H.Y. ParallelDSM: A R package for parallel soil mapping. Computers & Geosciences (to be available in 2021)
}
