% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{mczf}
\alias{mczf}
\title{The Monte Carlo permutation test for Gaussian conditional independence test}
\usage{
mczf(x, y, S, suffStat)
}
\arguments{
\item{x,y,S}{It is tested, whether x and y are conditionally independent given the subset S of
the remaining nodes. x, y, S all are integers, corresponding to variable or node
numbers.}

\item{suffStat}{The dataset in matrix format with rows are samples and columns are variables.}
}
\value{
the p-value of the test.
}
\description{
The Monte Carlo permutation test for Gaussian conditional independence test. See the mc-zf function in the bnlearn package for more details.
}
\examples{
##########################################
## Using mczf
##########################################
library(bnlearn)
library(pcalg)
data("gmG")
suffStat<-gmG$x
mczf(1,2,3,suffStat)
}
\references{
Marco Scutari (2010). Learning Bayesian Networks with the bnlearn R Package. Journal of Statistical Software, 35(3), 1-22.
}

