% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParamLengths.R
\name{getParamLengths}
\alias{getParamLengths}
\title{Return lengths of single parameters or parameters in parameter set.}
\usage{
getParamLengths(par, dict = NULL)
}
\arguments{
\item{par}{[\code{\link{Param}} | \code{\link{ParamSet}}]\cr
Parameter or parameter set.}

\item{dict}{[\code{environment} | \code{list} | \code{NULL}]\cr
Environment or list which will be used for evaluating the variables
of expressions within a parameter, parameter set or list of parameters.
The default is \code{NULL}.}
}
\value{
[\code{integer}]. Named and in the same order as the input for \code{\link{ParamSet}} input.
}
\description{
Useful for vector parameters.
}
\examples{
ps = makeParamSet(
  makeNumericParam("u"),
  makeIntegerParam("v", lower = 1, upper = 2),
  makeDiscreteParam("w", values = 1:2),
  makeDiscreteVectorParam("x", len = 2, values = c("a", "b"))
)
getParamLengths(ps)
# the length of the vector x is 2, for all other single value parameters the length is 1.

par = makeNumericVectorParam("x", len = expression(k), lower = 0)
getParamLengths(par, dict = list(k = 4))
}
