% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/OptPath_getter.R
\name{getOptPathBestIndex}
\alias{getOptPathBestIndex}
\title{Get index of the best element from optimization path.}
\usage{
getOptPathBestIndex(op, y.name = op$y.names[1], dob = op$env$dob,
  eol = op$env$eol, ties = "last")
}
\arguments{
\item{op}{[\code{\link{OptPath}}]\cr
Optimization path.}

\item{y.name}{[\code{character(1)}]\cr
Name of target value to decide which element is best.
Default is \code{y.names[1]}.}

\item{dob}{[\code{integer}]\cr
Vector of date-of-birth values to further subset the result.
Only elements with a date-of-birth included in \code{dob} are selected.
Default is all.}

\item{eol}{[\code{integer}]\cr
Vector of end-of-life values to further subset the result.
Only elements with an end-of-life included in \code{eol} are selected.
Default is all.}

\item{ties}{[\code{character(1)}]\cr
How should ties be broken when more than one optimal element is found?
\dQuote{all}: return all indices,
\dQuote{first}: return first optimal element in path,
\dQuote{last}: return last optimal element in path,
\dQuote{random}: return random optimal element in path.
Default is \dQuote{last}.}
}
\value{
[\code{integer}]
  Index or indices into path. See \code{ties}.
}
\description{
Get index of the best element from optimization path.
}
\examples{
ps = makeParamSet(makeNumericParam("x"))
op = makeOptPathDF(par.set = ps, y.names = "y", minimize = TRUE)
addOptPathEl(op, x = list(x = 1), y = 5)
addOptPathEl(op, x = list(x = 2), y = 3)
addOptPathEl(op, x = list(x = 3), y = 9)
addOptPathEl(op, x = list(x = 4), y = 3)
as.data.frame(op)
getOptPathBestIndex(op)
getOptPathBestIndex(op, ties = "first")
}
\seealso{
Other optpath: \code{\link{OptPath}},
  \code{\link{OptPathDF}}, \code{\link{makeOptPathDF}};
  \code{\link{addOptPathEl}}; \code{\link{getOptPathCols}};
  \code{\link{getOptPathCol}}; \code{\link{getOptPathDOB}};
  \code{\link{getOptPathEOL}}; \code{\link{getOptPathEl}};
  \code{\link{getOptPathErrorMessages}};
  \code{\link{getOptPathExecTimes}};
  \code{\link{getOptPathLength}};
  \code{\link{getOptPathParetoFront}};
  \code{\link{getOptPathX}}; \code{\link{getOptPathY}};
  \code{\link{setOptPathElDOB}};
  \code{\link{setOptPathElEOL}}
}

