% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ParamSet.R
\name{makeParamSet}
\alias{ParamSet}
\alias{makeNumericParamSet}
\alias{makeParamSet}
\title{Construct a parameter set.}
\usage{
makeParamSet(..., params, forbidden = NULL)

makeNumericParamSet(id = "x", len, lower = -Inf, upper = Inf,
  vector = TRUE)
}
\arguments{
\item{...}{[\code{\link{Param}}]\cr
Parameters.}

\item{params}{[list of \code{\link{Param}}]\cr
List of parameters, alternative way instead of using \code{...}.}

\item{forbidden}{[\code{NULL} | R expression]\cr
States forbidden region of parameter set via an expression.
Every setting which satisfies this expression is considered to be infeasible.
This makes it possible to exclude more complex region of the parameter space
than through simple constraints or \code{requires}-conditions
(although these should be always used when possible).
If parameters have associated trafos, the forbidden region must always be specified on the original
scale and not the transformed one.
Default is \code{NULL} which means no forbidden region.}

\item{id}{[\code{character(1)}]
Name of parameter.}

\item{len}{[\code{integer(1)}]\cr
Length of vector.}

\item{lower}{[\code{numeric}]\cr
Lower bound.
Default is \code{-Inf}.}

\item{upper}{[\code{numeric}] \cr
Upper bound.
Default is \code{Inf}.}

\item{vector}{[\code{logical(1)}] \cr
Should a \code{NumericVectorParam} be used instead of
n \code{NumericParam} objects?
Default is \code{TRUE}.}
}
\value{
[\code{\link{ParamSet}}].
}
\description{
\code{makeParamSet}: Contruct from a bunch of parameters.

Multiple sets can be concatenated with \code{c}.

The constructed S3 class is simply a list that contains the element \code{pars}.
\code{pars} is a list of the passed parameters, named by their ids.

\code{makeNumericParamSet}: Convenience function for numerics.
}
\examples{
makeParamSet(
  makeNumericParam("u", lower=1),
  makeIntegerParam("v", lower=1, upper=2),
  makeDiscreteParam("w", values=1:2),
  makeLogicalParam("x"),
  makeDiscreteVectorParam("y", len=2, values=c("a", "b"))
)
}

