% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCharacteristics.R
\name{summariseCharacteristics}
\alias{summariseCharacteristics}
\title{Summarise characteristics of individuals}
\usage{
summariseCharacteristics(
  cohort,
  cdm = lifecycle::deprecated(),
  strata = list(),
  demographics = TRUE,
  ageGroup = NULL,
  tableIntersect = list(),
  cohortIntersect = list(),
  conceptIntersect = list(),
  otherVariables = character()
)
}
\arguments{
\item{cohort}{A cohort in the cdm}

\item{cdm}{A cdm reference.}

\item{strata}{Stratification list}

\item{demographics}{Whether to summarise demographics data.}

\item{ageGroup}{A list of age groups.}

\item{tableIntersect}{A list of arguments that uses addTableIntersect
function to add variables to summarise}

\item{cohortIntersect}{A list of arguments that uses addCohortIntersect
function to add variables to summarise.}

\item{conceptIntersect}{A list of arguments that uses addConceptIntersect
function to add variables to summarise.}

\item{otherVariables}{Other variables contained in cohort that you want to be
summarised.}
}
\value{
A summary of the characteristics of the individuals
}
\description{
Summarise characteristics of individuals
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

summariseCharacteristics(
  cohort = cdm$cohort1,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150)),
  tableIntersect = list(
    tableName = "visit_occurrence", value = "count", window = c(-365, -1)
  ),
  cohortIntersect = list(
    targetCohortTable = "cohort2", value = "flag", window = c(-365, -1)
  )
)
}
}
