% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSummarised.R
\name{tableTableIntersect}
\alias{tableTableIntersect}
\title{Format a summariseTableIntersect result into a visual table.}
\usage{
tableTableIntersect(
  result,
  type = "gt",
  formatEstimateName = c(`N (\%)` = "<count> (<percentage>\%)", `Median [Q25 - Q75]` =
    "<median> [<q25> - <q75>]", `Mean (SD)` = "<mean> (<sd>)", Range = "<min> to <max>"),
  header = c("group"),
  split = c("group", "strata"),
  groupColumn = NULL,
  minCellCount = 5,
  excludeColumns = c("result_id", "result_type", "package_name", "package_version",
    "estimate_type", "variable_level", "additional_name", "additional_level"),
  .options = list()
)
}
\arguments{
\item{result}{A result from summariseTableIntersect.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: `cdm_name`, `group`, `strata`, `additional`,
`variable`, `estimate`, `settings`.}

\item{split}{A vector containing the name-level groups to split ("group",
"strata", "additional"), or an empty character vector to not split.}

\item{groupColumn}{Column to use as group labels.}

\item{minCellCount}{Counts below which results will be clouded.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
PatientProfiles::optionsTableCharacteristics() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of a summariseTableIntersect
result.
}
\description{
`r lifecycle::badge("deprecated")`
}
