% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Return.convert.R
\name{Return.convert}
\alias{Return.convert}
\title{Convert coredata content from one type of return to another}
\usage{
Return.convert(
  R,
  destinationType = c("discrete", "log", "difference", "level"),
  seedValue = NULL,
  initial = TRUE
)
}
\arguments{
\item{R}{an xts object}

\item{destinationType}{one of 'discrete', 'log', 'difference' or 'level'}

\item{seedValue}{a numeric scalar indicating the (usually initial) index level or price of the series}

\item{initial}{(default TRUE) a TRUE/FALSE flag associated with 'seedValue', indicating if this value is at the begginning of the series (TRUE) or at the end of the series (FALSE)}
}
\description{
This function takes an xts object, and using its attribute information, will convert 
information in the object into the desired output, selected by the user.  For example, all 
combinations of moving from one of 'discrete', 'log', 'difference' and 'level', to another different
data type (from the same list) are permissible.
}
\examples{
# TBD

}
\seealso{
\code{\link{Return.calculate}}
}
\author{
Erol Biceroglu
}
