% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RandomEffTox}
\alias{RandomEffTox}
\title{Randomizes Eff-Tox dose proportional to posterior desireability scores.}
\usage{
RandomEffTox(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars,
  Contour, PiLim, ProbLim, B)
}
\arguments{
\item{YE}{Vector containing observed efficacy indicators.}

\item{YT}{Vector containing observed toxicity indicators.}

\item{Doses}{Vector containing numbered Doses of patients in trial.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{DosesTried}{Binary vector corresponding to which doses have been tried.}

\item{Hypermeans}{Vector containing prior hypermeans of length 6 for Eff-Tox parameters.}

\item{Hypervars}{Vector containing prior hypervariances of length 6 for Eff-Tox parameters.}

\item{Contour}{Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.}

\item{PiLim}{Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.}

\item{ProbLim}{Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.}

\item{B}{Number of iterations to perform in the MCMC.}
}
\value{
A random dose level to administer the next patient cohort.
}
\description{
This function returns a random acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
}
\examples{
##Doses, YE,YT
Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
##Vector of Numerical Doses
Dose = c(1,2,3,3.5,5)
Dose=(Dose-mean(Dose))/sd(Dose)
##Five doses, but only 3 tried so we have
DosesTried=c(1,1,1,0,0)
## Contour Vector
Contour = c(.35, .75,.7,.4)
##Hypermeans
Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
Hypervars=Hypervars^2
##Acceptability Criteria
PiLim = c(.3,.4)
ProbLim=c(.1,.1)
##Number of iterations
B=2000
RandomEffTox(YE,YT, Doses, Dose, DosesTried, Hypermeans,  Hypervars, Contour, PiLim,  ProbLim, B )
}
