% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phitest.R
\name{phitest.matrix}
\alias{phitest.matrix}
\title{Appling the Phitest method with a count matrix}
\usage{
\method{phitest}{matrix}(object, label, ncores = 1, min.cell = 10)
}
\arguments{
\item{object}{A matrix of single-cell UMI counts (rows for genes and columns for cells).}

\item{label}{A character or numeric vector of cluster labels. Length should be the same as
cell number and order should match the order in \code{object}.}

\item{ncores}{Number of cores used for parallel computation.}

\item{min.cell}{An integer specifying a threshold to filter genes. Genes expressed in
fewer than \code{min.cell} cells are filtered out.}
}
\value{
A list of two elements: \code{pval} contains the \emph{P} values, and
\code{par} contains the estimated parameters.
}
\description{
Phitest for analyzing the heterogeneity of single-cell populations
}
\author{
Wei Vivian Li, \email{vivian.li@rutgers.edu}
}
