% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M_step.R
\name{estimate.alpha}
\alias{estimate.alpha}
\title{Function to estimate alpha}
\usage{
estimate.alpha(phylo, conditional_law_X, sigma2, mu, shifts, alpha_old,
  max_selection.strength)
}
\arguments{
\item{phylo}{Input tree.}

\item{conditional_law_X}{result of function \code{compute_E.OU}}

\item{sigma2}{variance of params}

\item{mu}{mean of the root state}

\item{shifts}{list of shifts on the tree}

\item{alpha_old}{previous estimation of the selection strength}

\item{max_selection.strength}{the maximal value of alpha authorized by
the user}
}
\value{
double : estimation of alpha
}
\description{
\code{optimize} to maximize the
conditional expectation log likelihood in alpha. The interval is
set to [alpha_old/2, 2*alpha_old], supposing that the previous guess of 
alpha_old is not far from reality.
}
\details{
This function uses functions \code{compute_var_diff.OU} 
and \code{compute_diff_exp.OU} in the process. Carefull : only works if the
root is stationary, and shifts at nodes.
}
\keyword{internal}
