% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wearingMarking.R
\name{wearingMarking}
\alias{wearingMarking}
\title{Classify Wear and Nonwear Time for Accelerometer Data}
\usage{
wearingMarking(dataset, frame = 90, perMinuteCts = 60,
  TS = getOption("pa.timeStamp"), cts = getOption("pa.cts"),
  streamFrame = NULL, allowanceFrame = 2, newcolname = "wearing",
  getMinuteMarking = FALSE, dayStart = "00:00:00", tz = "UTC", ...)
}
\arguments{
\item{dataset}{The source dataset, in dataframe format, which needs to be
marked.}

\item{frame}{The size of time interval to be considered; Window 1 described
in Choi \emph{et al.} (2011). The default is 90.}

\item{perMinuteCts}{The number of data rows per minute. The default is 1-sec
epoch (perMinuteCts = 60). For examples: for data with 10-sec epoch, set
perMinuteCts = 6; for data with 1-min epoch, set perMinuteCts = 1.}

\item{TS}{The column name for timestamp. The default is \dQuote{TimeStamp}.}

\item{cts}{The column name for counts. The default is \dQuote{axis1}.}

\item{streamFrame}{The size of time interval that the program will look back
or forward if activity is detected; Window 2 described in Choi \emph{et al.}
(2011). The default is the half of the frame.}

\item{allowanceFrame}{The size of time interval that zero counts are allowed;
the artifactual movement interval described in Choi \emph{et al.} (2011).
The default is 2.}

\item{newcolname}{The column name for classified wear and nonwear status. The
default is \dQuote{wearing}.  After the data is processed, a new field will 
be added to the original dataframe. This new field is an indicator for the
wearing (\dQuote{w}) or nowwearing (\dQuote{nw}).}

\item{getMinuteMarking}{Return minute data with wear and nonwear
classification. If the source is not a minute dataset, the function will
collapse it into minute data. The default is FALSE.}

\item{dayStart}{Define the starting time of day. The default is the midnight,
"00:00:00". It must be in the format of "hh:mm:ss".}

\item{tz}{Local time zone, defaults to UTC.}

\item{\dots}{Parameter settings that will be used in
\code{\link{dataCollapser}} function.}
}
\value{
A data frame with the column for wear and nonwear classification
indicator by epoch-by-epoch basis.
}
\description{
This function classifies wear and nonwear time status for accelerometer
data by epoch-by-epoch basis.
}
\details{
A detailed description of the algorithm implemented in this function is
described in Choi \emph{et al.} (2011).
}
\note{
Warning: It will be very slow if accelerometer data with 1-sec epoch
for many days are directly classified. We recommend to collapse a dataset
with 1-sec epoch to 1-min epoch data using \code{\link{dataCollapser}} and
then classify wear and nonwear status using a dataset with a larger epoch.
}
\examples{
data(dataSec)

## mark data with 1-min epoch
mydata1m = dataCollapser(dataSec, TS = "TimeStamp", col = "counts", by = 60)

data1m = wearingMarking(dataset = mydata1m,
                       frame = 90, 
                       perMinuteCts = 1,
                       TS = "TimeStamp",
                       cts = "counts", 
                       streamFrame = NULL, 
                       allowanceFrame= 2, 
                       newcolname = "wearing")

sumVct(data1m, id="dataid")

## mark data with 1-sec epoch
\dontrun{
data1s = wearingMarking(dataset = dataSec,
                       frame = 90, 
                       perMinuteCts = 60,
                       TS = "TimeStamp",
                       cts = "counts", 
                       streamFrame = NULL, 
                       allowanceFrame= 2, 
                       newcolname = "wearing",
                       getMinuteMarking = FALSE)

sumVct(data1s, id="dataid")
sumVct(data1s, id="dataid", markingString = "nw")
}
}
\references{
Choi L, Liu Z, Matthews CE, Buchowski MS. 
Validation of accelerometer wear and nonwear time classification algorithm.
Med Sci Sports Exerc. 2011 Feb;43(2):357-64.
}
\seealso{
\code{\link{readCountsData}}, \code{\link{sumVct}}
}
\author{
Leena Choi \email{leena.choi@Vanderbilt.Edu},
Cole Beck \email{cole.beck@vumc.org},
Zhouwen Liu \email{zhouwen.liu@vumc.org},
Charles E. Matthews \email{Charles.Matthews2@nih.gov}, and
Maciej S. Buchowski \email{maciej.buchowski@Vanderbilt.Edu}
}
