% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltree.R
\name{pltree}
\alias{pltree}
\title{Plackett-Luce Trees}
\usage{
pltree(formula, data, subset, na.action, cluster, ref = NULL, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be fitted, of the form
\code{y ~ x1 + ... + xn} where \code{y} should be an object of class
\code{\link{grouped_rankings}} and \code{x1}, \dots, \code{xn} are used as
partitioning variables.}

\item{data}{an optional data frame containing the variables in the model.}

\item{subset}{A specification of the rows to be used, passed to
\code{\link{model.frame}}.}

\item{na.action}{how NAs are treated, applied to the underlying rankings and
then passed to \code{\link{model.frame}}.}

\item{cluster}{an optional vector of cluster IDs to be employed for clustered
covariances in the parameter stability tests, see \code{\link{mob}}.}

\item{ref}{an integer or character string specifying the reference item (for
which log ability will be set to zero). If NULL the first item is used.}

\item{...}{additional arguments, passed to \code{\link{PlackettLuce}}.}
}
\value{
An object of class \code{"pltree"} inheriting from \code{"bttree"}
and \code{"modelparty"}.
}
\description{
Recursive partitioning based on Plackett-Luce models.
}
\details{
Plackett-Luce trees are an application of model-based recursive partitioning
(implemented in \code{\link[partykit]{mob}}) to Plackett-Luce models for
rankings. The partitioning is based on ranking covariates, e.g. attributes of
the judge making the ranking, or conditions under which the ranking is made.
The response should be a \code{\link{grouped_rankings}} object that groups
rankings with common covariate values. This may be included in a data frame
alongside the covariates.

Most arguments of \code{PlackettLuce} can be passed on by \code{pltree}.
However, Plackett-Luce tree with fixed adherence are not implemented.
Arguably it makes more sense to estimate adherence or reliability within
the nodes of the Plackett-Luce tree.

Various methods are provided for \code{"pltree"} objects, most of them
inherited from \code{"modelparty"} objects (e.g. \code{print},
\code{summary}), or \code{"bttree"} objects (\code{plot}). The plot
method employs the \code{\link[psychotree]{node_btplot}}
panel-generating function. The See Also
section gives details of separately documented methods.
}
\examples{
# Bradley-Terry example

if (require(psychotree)){
    ## Germany's Next Topmodel 2007 data
    data("Topmodel2007", package = "psychotree")
    ## convert paircomp object to grouped rankings
    R <- as.grouped_rankings(Topmodel2007$preference)
    ## rankings are grouped by judge
    print(R[1:2,], max = 4)
    ## Topmodel2007[, -1] gives covariate values for each judge
    print(Topmodel2007[1:2, -1])

    ## fit partition model based on all variables except preference
    ## set npseudo = 0 as all judges rank all models
    tm_tree <- pltree(R ~ ., data = Topmodel2007[, -1], minsize = 5,
                      npseudo = 0)

    ## plot shows abilities constrained to sum to 1
    plot(tm_tree, abbreviate = 1, yscale = c(0, 0.5))
    ## instead show log-abilities with Anja as reference (need to used index)
    plot(tm_tree, abbreviate = 1, worth = FALSE, ref = 6,
         yscale = c(-1.5, 2.2))

    ## log-abilities, zero sum contrast
    itempar(tm_tree, log = TRUE)
}
}
\seealso{
\code{\link[psychotree]{bttree}} For fitting Bradley-Terry trees
(equivalent to the Plackett-Luce model for paired comparisons without ties).

\code{coef}, \code{vcov}, \code{AIC} and \code{predict} methods are documented on
\code{\link{pltree-summaries}}.

\code{\link[=itempar.PlackettLuce]{itempar}}, extracts the abilities or item parameters
in each node of the tree using \code{\link{itempar.PlackettLuce}}.

\code{\link[=fitted.PlackettLuce]{fitted}}, computes probabilities for the observed
choices based on the full tree.
}
