% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Affine.R
\name{Affine}
\alias{Affine}
\title{R6 class representing an affine map.}
\description{
An affine map is given by a 2x2 matrix
(a linear transformation) and a vector (the "intercept").
}
\examples{

## ------------------------------------------------
## Method `Affine$print`
## ------------------------------------------------

Affine$new(rbind(c(3.5,2),c(0,4)), c(-1, 1.25))
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{A}}{get or set the matrix \code{A}}

\item{\code{b}}{get or set the vector \code{b}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Affine-new}{\code{Affine$new()}}
\item \href{#method-Affine-print}{\code{Affine$print()}}
\item \href{#method-Affine-get3x3matrix}{\code{Affine$get3x3matrix()}}
\item \href{#method-Affine-inverse}{\code{Affine$inverse()}}
\item \href{#method-Affine-compose}{\code{Affine$compose()}}
\item \href{#method-Affine-transform}{\code{Affine$transform()}}
\item \href{#method-Affine-transformLine}{\code{Affine$transformLine()}}
\item \href{#method-Affine-transformEllipse}{\code{Affine$transformEllipse()}}
\item \href{#method-Affine-clone}{\code{Affine$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-new"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Affine} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$new(A, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{A}}{the 2x2 matrix of the affine map}

\item{\code{b}}{the shift vector of the affine map}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Affine} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-print"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{Affine} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Affine$new(rbind(c(3.5,2),c(0,4)), c(-1, 1.25))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-get3x3matrix"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-get3x3matrix}{}}}
\subsection{Method \code{get3x3matrix()}}{
The 3x3 matrix representing the affine map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$get3x3matrix()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-inverse"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-inverse}{}}}
\subsection{Method \code{inverse()}}{
The inverse affine transformation, if it exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$inverse()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-compose"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-compose}{}}}
\subsection{Method \code{compose()}}{
Compose the reference affine map with another
affine map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$compose(transfo, left = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transfo}}{an \code{Affine} object}

\item{\code{left}}{logical, whether to compose at left or at right (i.e.
returns \code{f1 o f0} or \code{f0 o f1})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Affine} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-transform}{}}}
\subsection{Method \code{transform()}}{
Transform a point or several points by the reference affine map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-transformLine"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-transformLine}{}}}
\subsection{Method \code{transformLine()}}{
Transform a line by the reference affine transformation
(only for invertible affine maps).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-transformEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-transformEllipse}{}}}
\subsection{Method \code{transformEllipse()}}{
Transform an ellipse by the reference affine transformation
(only for an invertible affine map).
The result is an ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$transformEllipse(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{an \code{Ellipse} object or a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Ellipse} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Affine-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Affine-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Affine$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
