% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicfi_utils.R
\name{sequential_download_paths}
\alias{sequential_download_paths}
\title{Download the Planet NICFI images sequentially}
\usage{
sequential_download_paths(
  aria2c_file_paths,
  default_directory,
  download_method = "wget",
  verbosity = 0
)
}
\arguments{
\item{aria2c_file_paths}{a vector of character strings. See the output of the 'aria2c_download_paths()' function for the correct format.}

\item{default_directory}{a character string specifying a valid path where the files will be saved}

\item{download_method}{a character string specifying the download method. Can be for instance "wget", "curl" or any available method of the "download.file()" function}

\item{verbosity}{an integer specifying the verbosity (between 0 and 2). If 0 then verbosity is disabled, if 1 then only essential verbosity is displayed and if 2 then all available information will be printed out in the console.}
}
\value{
it doesn't return an R object but it saves the files to a directory
}
\description{
Download the Planet NICFI images sequentially
}
\details{
This function does not require the 'aria2c' tool (system requirement) to download the imagery. It uses the 'utils::download.file()' function internally
}
\examples{

\dontrun{

require(PlanetNICFI)

#....................................
# first extract the available Mosaics
#....................................

api_key = 'use_your_planet_nicfi_API_key'

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'monthly',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)

#....................................
# keep the mosaic of 'September 2020'
#....................................

keep_idx = 1
mosaic_ID = mosaic_files$dtbl_mosaic$id[keep_idx]


#.....................................................
# then extract the available Quad files for the Mosaic
#.....................................................

wkt_file = system.file('data_files/Sugar_Cane_Bolivia.wkt', package = "PlanetNICFI")
WKT = readLines(wkt_file, warn = FALSE)

quad_files = nicfi_quads_bbox(planet_api_key = api_key,
                              mosaic_id = mosaic_ID,
                              bbox_AOI = NULL,
                              wkt_AOI = WKT,
                              page_size = 10,
                              crs_bbox = 4326,
                              verbose = TRUE)
#........................
# download the .tif files
#........................

web_links_aria2c = aria2c_download_paths(mosaic_output = mosaic_files,
                                         mosaic_id = mosaic_ID,
                                         quads_output = quad_files,
                                         img_type = 'tif')

DIR_SAVE = tempdir(check = FALSE)
print(DIR_SAVE)

res_dat = sequential_download_paths(aria2c_file_paths = web_links_aria2c,
                                    default_directory = DIR_SAVE,
                                    download_method = 'wget',
                                    verbosity = 1)
}
}
