% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_DEgenes.R
\name{GEX_DEgenes}
\alias{GEX_DEgenes}
\title{Extracts the differentially expressed genes between two groups of cells. These groups are defined as cells having either of two entries (group1, group2) in the grouping.column of the input Seurat object metadata This function uses the FindMarkers function from the Seurat package.}
\usage{
GEX_DEgenes(
  GEX,
  FindMarkers.out,
  grouping.column,
  group1,
  group2,
  min.pct,
  filter,
  return.plot,
  logFC,
  color.p.threshold,
  color.log.threshold,
  color.by.threshold,
  up.genes,
  down.genes,
  base,
  label.n.top.genes,
  genes.to.label
)
}
\arguments{
\item{GEX}{Output Seurat object from automate_GEX or VDJ_GEX_matrix_function (VDJ_GEX_matrix.output[[2]]) function that contained at least two distinct biological groups.}

\item{FindMarkers.out}{OPTIONAL: the output of the FindMarkers function. This skips the DEG calculation step and outputs desired plots. All plotting parameters function as normal. Grouping parameters and min.pct are ignored.}

\item{grouping.column}{Character. A column name of GEX@meta.data. In this column, group1 and group2 should be found. Defaults to "sample_id". Could also be set to "seurat_clusters" to generate DEGs between cells of 2 chosen clusters.}

\item{group1}{either character or integer specifying the first group of cells that should be compared. (e.g. "s1" if sample_id is used as grouping.column)}

\item{group2}{either character or integer specifying the first group of cells that should be compared. (e.g. "s2" if sample_id is used as grouping.column)}

\item{min.pct}{The minimum percentage of cells expressing a gene in either of the two groups to be compared.}

\item{filter}{Character vector of initials of the genes to be filtered. Default is c("MT-", "RPL", "RPS"), which filters mitochondrial and ribosomal genes.}

\item{return.plot}{Character specifying if a "heatmap", or a "volcano" or "none" is to be returned. If not "none" then @return is a list where the first element is a dataframe and the second a plot (see @return). Defaults to none}

\item{logFC}{Logical specifying whether the genes will be displayed based on logFC (TRUE) or pvalue (FALSE).}

\item{color.p.threshold}{numeric specifying the adjusted p-value threshold for geom_points to be colored. Default is set to 0.01.}

\item{color.log.threshold}{numeric specifying the absolute logFC threshold for geom_points to be colored. Default is set to 0.25.}

\item{color.by.threshold}{Boolean. Set to TRUE to color by color.p.threshold and color.log.threshold. Set to FALSE for a continuous color scale by fold change.}

\item{up.genes}{FOR HEATMAP Integer specifying the number of upregulated genes to be shown.}

\item{down.genes}{FOR HEATMAP Integer specifying the number of downregulated genes to be shown.}

\item{base}{The base with respect to which logarithms are computed. Default: 2}

\item{label.n.top.genes}{FOR VOLCANO Interger. How many top genes to label either by Fold change (if logFC == TRUE) or by p.value (if logFC == FALSE). More than 50 are not recommended. Also works in conjunction with genes.to.label}

\item{genes.to.label}{FOR VOLCANO Character vector of genes to label irregardless of their p value.}
}
\value{
Returns a list with out[[1]] = a dataframe containing the output from the FindMarkers function, which contains information regarding the genes that are differentially regulated, statistics (p value and log fold change), and the percent of cells expressing the particular gene for both groups. out[[2]] = either a "heatmap" (set return.plot accordingly), or "volcano" plot
}
\description{
Extracts the differentially expressed genes between two groups of cells. These groups are defined as cells having either of two entries (group1, group2) in the grouping.column of the input Seurat object metadata This function uses the FindMarkers function from the Seurat package.
}
\examples{
#Basic run between two samples
GEX_DEgenes(GEX = Platypus::small_vgm[[2]],min.pct = .25,
group1 = "s1",group2 = "s2")

#Getting DEGs between two seurat clusters
#GEX_DEgenes(GEX = Platypus::small_vgm[[2]],min.pct = .25,
#grouping.column = "seurat_clusters",group1 = "0",group2 = "1")

#Plotting a heatmap by foldchange of sample markers
#GEX_DEgenes(GEX = VDJ_GEX_matrix.output[[2]]
#,min.pct = .25,group1 = "s1",group2 = "s2", return.plot = "heatmap"
#, up.genes = 10, down.genes = 10, logFC = TRUE)

#Plotting volcano by p value of sample markers. Label additional genes of interest
#GEX_DEgenes(GEX = VDJ_GEX_matrix.output[[2]],min.pct = .25
#,group1 = "s1",group2 = "s2", return.plot = "volcano", logFC = FALSE
#, label.n.top.genes = 40, genes.to.label = c("CD28", "ICOS"))

#Generate a heatmap from an already existing FindMarkers output
#GEX_DEgenes(GEX = VDJ_GEX_matrix.output[[2]]
#, FindMarkers.out = FindMarkers.output.dataframe, return.plot = "heatmap"
#, up.genes = 10, down.genes = 10, logFC = TRUE, platypus.version = "v3")
}
