% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_extract_germline.R
\name{VDJ_extract_germline}
\alias{VDJ_extract_germline}
\title{Only Platypus v2 Extracts the full-length germline sequence as determined by cellranger. This function returns an object that now contains the reference germline for each of the clones. If multiple clones (as determined by cellranger) have been merged using the VDJ_clonotype function then these sequences may have distinct germline sequences despite being in the same clonal family (nested list). This is particularly possible when homology thresholds were used to determine the clonotypes.}
\usage{
VDJ_extract_germline(
  VDJ.per.clone,
  mixcr.directory,
  extract.VDJRegion,
  species
)
}
\arguments{
\item{VDJ.per.clone}{The output from the VDJ_per_clone function. This object should have information regarding the contigs and clonotype_ids for each cell.}

\item{mixcr.directory}{The directory containing an executable version of MiXCR. This must be downloaded separately and is under a separate license.}

\item{extract.VDJRegion}{Default is TRUE. Future iterations will allow for distinct gene regions to be extracted.}

\item{species}{Either "mus" or "hsa" for mouse and human respectively. Default is set to mouse.}
}
\value{
Returns a dataframe containing repertoire information, such as isotype, CDR sequences, mean number of UMIs. This output can be supplied to furhter packages VDJ_extract_sequences and VDJ_GEX_integrate
}
\description{
Only Platypus v2 Extracts the full-length germline sequence as determined by cellranger. This function returns an object that now contains the reference germline for each of the clones. If multiple clones (as determined by cellranger) have been merged using the VDJ_clonotype function then these sequences may have distinct germline sequences despite being in the same clonal family (nested list). This is particularly possible when homology thresholds were used to determine the clonotypes.
}
\examples{
\dontrun{
VDJ_extract_germline(VDJ.per.clone=VDJ.per.clone.output
,mixcr.directory="~/Downloads/mixcr-3.0.12/mixcr"
,extract.VDJRegion=T,species = "mmu")
}

}
