% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_paths.R
\name{AntibodyForests_paths}
\alias{AntibodyForests_paths}
\title{Calculates the longest/shortest paths from a node to a given node for the AntibodyForests minimum spanning trees / sequence similarity networks}
\usage{
AntibodyForests_paths(
  trees,
  graph.type,
  path.from,
  path.to,
  paths,
  interlevel.from,
  weighted,
  plot.results,
  color.by,
  cell.frequency,
  parallel
)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{graph.type}{string - the graph type available in the AntibodyForests object which will be used as the function input.
Currently supported network/analysis types: 'tree' (for the minimum spanning trees or sequence similarity networks obtained from the main AntibodyForests function), 'heterogeneous' for the bipartite graphs obtained via AntibodyForests_heterogeneous, 'dynamic' for the dynamic networks obtained from AntibodyForests_dynamics.}

\item{path.from}{string/list of strings/integer - starting nodes for a path. Options are either an integer, selecting the nth most abundant node, 'hub' to select the hub nodes, 'most_expanded' for the nodes with most cells, 'leaf' for leaf nodes, 'germline' for the germline node, or a list of the form list(feature, feature_value) to select nodes with a specific feature value.}

\item{path.to}{string/list of strings/integer - end nodes for a path. Options are either an integer, selecting the nth most abundant node, 'hub' to select the hub nodes, 'most_expanded' for the nodes with most cells, 'leaf' for leaf nodes, 'germline' for the germline node, or a list of the form list(feature, feature_value) to select nodes with a specific feature value.}

\item{paths}{string - whether to calculate the longest path ('longest'), shortest path ('shortest'), or both (c('longest', 'shortest'))}

\item{interlevel.from}{string/list of strings/integer - starting nodes for an interlevel path for the bipartite/heterogeneous networks (if graph.type = 'heterogeneous'). Options are either an integer, selecting the nth most abundant node, 'hub' to select the hub nodes, 'most_expanded' for the nodes with most cells, 'leaf' for leaf nodes, 'germline' for the germline node, or a list of the form list(feature, feature_value) to select nodes with a specific feature value.}

\item{weighted}{boolean - whether to calculate the weighted or unweighted shortest/longest paths.}

\item{plot.results}{boolean - if T, will output a bar plot of node feature counts per path (of all nodes in a given path). Features are determined by the color.by parameter.}

\item{color.by}{string - features for the feature count per path bar plots if plot.results is set to T.}

\item{cell.frequency}{boolean - whether to consider the node or cell frequency for the feature counts in the resulting bar plot if plot.results is T.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package to be installed.}
}
\value{
nested list of AntibodyForests objects or a single object with a new slot - paths. If plot.results is T, will also output a bar plot of feature counts per path (considering all node in a given path).
}
\description{
Calculates the longest or shortest paths in a given AntibodyForests graph from a node to another given node. Nodes can be specified as integers (e.g., path.from = 5, picking the fifth node in the igraph vertex list) or by predetermined attributes (e.g., path.from = 'germline' and path.to = 'hub' will calculate the paths between all germlines and hubs in a set of networks.
Moreover, there is an option to select paths for nodes given specific node features (e.g., path.from = list('seurat_clusters', '1') and path.to = 'hub' will infer the paths from the nodes with a majority of Seurat clusters = 1, and to the hub nodes).
}
\examples{
\dontrun{
AntibodyForests_paths(trees, graph.type = 'tree',
path.from = 'germline', path.to = 'leaf',
plot.results = T, color.by = 'seurat_clusters')
}
}
