% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_pseudotime_trajectory_plot.R
\name{GEX_pseudotime_trajectory_plot}
\alias{GEX_pseudotime_trajectory_plot}
\title{This function plots pseudotime along the trajectories which have been constructed with the GEX_trajectories() function.}
\usage{
GEX_pseudotime_trajectory_plot(cds, root.nodes, monocle.version, root.state)
}
\arguments{
\item{cds}{cell data set object. Output element [[1]] of the GEX_trajectories() function}

\item{root.nodes}{For monocle3: Root nodes to determine for the pseudotime trajectories. GEX_trajectories output [[3]] yields all the possible root nodes. Choose the ones you like.}

\item{monocle.version}{Version of monocle. Either monocle2 or monocle3. Has to be the same as in GEX_trajectories().Default is monocle3.}

\item{root.state}{For monocle2: Root state to determine starting cluster for the pseudotime trajectories. GEX_trajectories ouput [[3]] yields all the possible root states Choose the one you like.}
}
\value{
Returns a list.Element [[1]] cell data set object with the pseudotime trajectories. Element [[2]] pseudotime trajectory plot
}
\description{
This function plots pseudotime along the trajectories which have been constructed with the GEX_trajectories() function.
}
\examples{
\dontrun{
##monocle3
pseudotime_output <- GEX_pseudotime_trajectory_plot(
GEX_trajectories_output[[1]], root.nodes = c('Y_742','Y_448','Y_964') )

##monocle2
pseudotime_output <- GEX_pseudotime_trajectory_plot(
GEX_trajectories_output[[1]], monocle.version = 'monocle3', root.state = "2")
 }
}
