% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexTrading.R
\name{ProcessTradingRequest}
\alias{ProcessTradingRequest}
\title{Process a trading request.}
\usage{
ProcessTradingRequest(theObject, command, args = list())
}
\arguments{
\item{theObject}{The Trading client API object on which the function should be called.}

\item{command}{- A length-one character vector.
Represents the trading command that should be executed by Poloniex.}

\item{args}{- list of optional trading arguments for the
trading command that should be executed.}
}
\value{
List - Results of the Trading Requests. Exact contents depend on the
 type of Trading API Call that should be processed.
}
\description{
Process a trading request.
}
\examples{
\dontrun{
poloniex.trading <- PoloniexTradingAPI(your.key, your.secret)
deposit.addresses <- ProcessTradingRequest(poloniex.trading,
 command = poloniex.trading@commands$returnDepositAddresses)
}
}
