% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoloniexTrading.R
\name{SetPoloniexTradingURL}
\alias{SetPoloniexTradingURL}
\title{Setter for REST service URL for the Poloniex Trading API}
\usage{
SetPoloniexTradingURL(theObject, trading.base.url)
}
\arguments{
\item{theObject}{The Trading client API object on which the function should be called}

\item{trading.base.url}{length-one character vector. Represents the REST service URL.}
}
\value{
theObject - a copy of the object with the modified trading.base.url slot
}
\description{
Setter for REST service URL for the Poloniex Trading API
}
\examples{
\dontrun{
poloniex.trading <- PoloniexTradingAPI(your.key, your.secret,
                                       trading.base.url = "https://not_working/trading?")
poloniex.trading <- SetPoloniexTradingURL(poloniex.trading, 
                                         trading.base.url = "https://poloniex.com/tradingApi?")
GetPoloniexTradingURL(poloniex.trading)
}
}
