% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{hapdos2hapcomb}
\alias{hapdos2hapcomb}
\title{convert haplotype dosages to haplotype combinations}
\usage{
hapdos2hapcomb(hapdos, ploidy)
}
\arguments{
\item{hapdos}{a vector with one item for some or all possible haplotypes,
with the dosage of the haplotypes, summing to ploidy; or a matrix where
each column is such a vector, each representing an individual. Missing data
are allowed (but any NA makes the entire vector or matrix column unknown);
if a matrix, 0 rows indicate missing values for all individuals.
When hapdos is a matrix, the haplotype numbers must be given as rownames;
when a vector, as names. Not all possible haplotype numbers need to be present
but the ones that are present must be in ascending order, no duplicates
or missing values allowed.}

\item{ploidy}{the ploidy (one number)}
}
\value{
a sorted vector of length ploidy with all haplotype numbers present,
or a matrix where each column is such a vector, with the same
colnames as hapdos
}
\description{
convert a vector or matrix of haplotype dosages to a vector
or matrix of haplotype combinations
}
\examples{
# specify haplotype dosages of 4 tetraploid individuals,
# only the 3 occurring haplotypes (1, 5 and 6) are given:
haplodosg <- matrix(c(1,2,1, 4,0,0, 0,4,0, 0,0,4), nrow=3,
                   dimnames=list(paste0("demohap_", c(1,5,6)), paste0("indiv", 1:4)))
# usage with hapdos as matrix:
hapdos2hapcomb(hapdos=haplodosg, ploidy=4)
# usage with hapdos as vector:
hapdos2hapcomb(hapdos=haplodosg[, 1], ploidy=4)
}
