% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Orthogonal_polynomials.R
\name{zap}
\alias{zap}
\alias{zap.default}
\alias{zap.polynom}
\alias{zap.polylist}
\alias{zap.list}
\title{Remove minuscule coefficients}
\usage{
zap(x, digits = getOption("digits"))

\method{zap}{default}(x, digits = getOption("digits"))

\method{zap}{polynom}(x, digits = getOption("digits"))

\method{zap}{polylist}(x, digits = getOption("digits"))

\method{zap}{list}(x, digits = getOption("digits"))
}
\arguments{
\item{x}{A polynomial or polylist object}

\item{digits}{As for \code{base::zapsmall}}

\item{...}{Passed on to \code{base::zapsmall}}
}
\value{
A polynomial or polylist object with minuscule coefficients set to zero.
}
\description{
A convenience function for setting polynomial coefficients likely
to be entirely round-off error to zero.  The decision is relegated
to the function \code{base::zapsmall}, to which this is a front-end.
}
\examples{
(P <- poly_orth(-2:2, norm = FALSE))
zap(35*P)
}
