% Generated by roxygen2 (4.0.1): do not edit by hand
\name{feps.prop}
\alias{feps.prop}
\title{RUV model:
Proportional.}
\usage{
feps.prop(model_switch, xt, parameters, epsi, poped.db)
}
\arguments{
\item{epsi}{A matrix with the same number of rows as the \code{xt} vector, colums match the numbers defined in this
function.}

\item{model_switch}{a vector of values, the same size as \code{xt}, identifying which model
response should be computed for the
corresponding xt value.  Used for multiple response models.}

\item{xt}{a vector of independent variable values (often time).}

\item{parameters}{A named list of parameter values.}

\item{poped.db}{a poped database.  This can be used to extract information that may be needed in the model file.}
}
\value{
A list consisting of:
\enumerate{
\item y the values of the model at the specified points.
\item poped.db A (potentially modified) poped database.
}
}
\description{
This is a residual unexplained variability (RUV) model function that encodes the model described above.
The function is suitable for input to the \code{\link{create.poped.database}} function using the
 \code{fError_file} argument.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=0.01,
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70)

##  create plot of model without variability 
plot_model_prediction(poped.db)

## evaluate initial design
FIM <- evaluate.fim(poped.db) 
FIM
det(FIM)
get_rse(FIM,poped.db)

}
\seealso{
Other RUV_models: \code{\link{feps.add.prop}};
  \code{\link{feps.add}}

Other models: \code{\link{feps.add.prop}};
  \code{\link{feps.add}};
  \code{\link{ff.PK.1.comp.oral.md.CL}};
  \code{\link{ff.PK.1.comp.oral.md.KE}};
  \code{\link{ff.PK.1.comp.oral.sd.CL}};
  \code{\link{ff.PK.1.comp.oral.sd.KE}};
  \code{\link{ff.PKPD.1.comp.oral.md.CL.imax}};
  \code{\link{ff.PKPD.1.comp.sd.CL.emax}}
}

