% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_params.R
\name{get_all_params}
\alias{get_all_params}
\title{Extract all model parameters from the PopED database.}
\usage{
get_all_params(poped.db)
}
\arguments{
\item{poped.db}{A PopED database.}
}
\value{
A list containing:
\item{bpop}{A vector of fixed effect parameter values.}
\item{d}{A vector of between subject variability parameters}
\item{covd}{A vector of the covariances of the between subject variability parameters.  Row major format of the lower triangular portion of the D (OMEGA) matrix}
\item{docc}{A vector of the between occasion variability (BOV) terms in the model}
\item{covdocc}{A vector of the covariances between the BOV terms.  Row major of the lower triangular portion of the BOV matrix. }
\item{sigma}{A vector of the resudual unexplained variances (RUV)}
\item{covsigma}{A vector of the covariances between the RUV terms}
\item{all}{A vector with all of the above, in the order of this list.}
}
\description{
Extract all model parameters from the PopED database.
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin example)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=0.01,
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70)

############# END ###################
## Create PopED database
## (warfarin example)
#####################################


get_all_params(poped.db)


}
\keyword{internal}

