% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.efficient.frontier.R
\name{meanrisk.efficient.frontier}
\alias{meanrisk.efficient.frontier}
\title{Generate multiple efficient frontiers for the same portfolio}
\usage{
meanrisk.efficient.frontier(
  portfolio,
  R,
  optimize_method = "CVXR",
  n.portfolios = 25,
  risk_type = "StdDev",
  compare_port = c("StdDev", "ES"),
  ...
)
}
\arguments{
\item{portfolio}{a portfolio object with constraints and objectives created via \code{\link{portfolio.spec}}}

\item{R}{an xts or matrix of asset returns}

\item{optimize_method}{the optimize method to get the efficient frontier, default is CVXR}

\item{n.portfolios}{number of portfolios to generate the efficient frontier}

\item{risk_type}{one of "StdDev", "ES" and "EQS", which determines the type of basic efficient frontier.}

\item{compare_port}{vector composed of any risk "StdDev", "ES", "EQS", for example, compare_port=c("StdDev", "ES")}

\item{\dots}{passthru parameters to \code{\link{optimize.portfolio}}}
}
\value{
a matrix of objective measure values and weights along the efficient frontier
}
\description{
This function generates the mean-risk efficient frontier of a portfolio
specifying the constraints and objectives. The \code{risk_type} object 
is for the basic mean-risk efficient frontier, other efficient frontiers
will be generated with the same target returns. All mean-StdDev, mean-ES
and mean-EQS efficient frontiers will be generated.
}
\author{
Xinran Zhao
}
