% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt.outputMvo.R
\name{opt.outputMvo}
\alias{opt.outputMvo}
\title{Optimal Portfolio Weights and Performance Values}
\usage{
opt.outputMvo(
  opt,
  returns,
  digits = NULL,
  annualize = TRUE,
  frequency = "monthly",
  rf = 0
)
}
\arguments{
\item{opt}{List output of `optimize.portfolio`}

\item{returns}{Multivariate xts object of portfolio assets returns}

\item{digits}{Integer number of significant digits with default NULL}

\item{annualize}{Logical with default TRUE}

\item{frequency}{Returns frequency: "monthly", "weekly" or "daily"}

\item{rf}{Numeric value with default 0.0}
}
\value{
A list containing the portfolio numeric weights, mean value,
volatility and Sharpe Ratio.
}
\description{
Converts output of `optimize.portfolio` to a list of the
portfolio weights, mean, volatility and Sharpe Ratio.
}
\details{
This function uses the weights returned by optimize.portfolio,
along with the portfolio assets returns, and a risk-free rate, to
to compute the portfolio mean return, volatility, and Sharpe Ratio.
}
\examples{
args(opt.outputMvo)
}
\author{
R. Douglas Martin
}
