% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_sectional.R
\name{calc_sector_breadth}
\alias{calc_sector_breadth}
\title{Calculate Market Breadth by Sector}
\usage{
calc_sector_breadth(
  condition_df,
  sector_mapping,
  min_stocks_per_sector = 3,
  na_sector_action = c("exclude", "separate", "market")
)
}
\arguments{
\item{condition_df}{Data frame with Date column and TRUE/FALSE values}

\item{sector_mapping}{Data frame with \code{Symbol} and \code{Sector} columns.}

\item{min_stocks_per_sector}{Minimum stocks for valid sector breadth (default: 3)}

\item{na_sector_action}{How to handle unmapped stocks: "exclude", "separate", or "market"}
}
\value{
A \code{data.table} with \code{Date} and \code{Breadth_[Sector]} columns (0–100 scale)
}
\description{
Measures participation within each sector separately, revealing which sectors
have broad strength vs concentrated leadership. Optimized using pre-splitting
for speed.
}
\examples{
data("sample_prices_weekly")
data("sample_sp500_sectors")
ma200 <- calc_moving_average(sample_prices_weekly, 200)
above_ma <- filter_above(calc_distance(sample_prices_weekly, ma200), 0)
sector_breadth <- calc_sector_breadth(above_ma, sample_sp500_sectors)
}
